/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector;

import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.ClassInjector;
import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.ClassLoaderHelper;
import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.ClassSource;
import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.InjectorClassLoader;
import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.InjectorClassLoaderFactory;

final class ClassInjectorImpl
extends ClassInjector {
    private final ClassSource source;
    private final ClassLoaderHelper classLoaderHelper;
    private final InjectorClassLoaderFactory injectorClassLoaderFactory;

    ClassInjectorImpl(ClassSource classSource, ClassLoaderHelper classLoaderHelper, InjectorClassLoaderFactory injectorClassLoaderFactory) {
        this.source = classSource;
        this.classLoaderHelper = classLoaderHelper;
        this.injectorClassLoaderFactory = injectorClassLoaderFactory;
    }

    @Override
    public void into(ClassLoader classLoader) {
        ClassLoaderHelper classLoaderHelper = this.classLoaderHelper;
        ClassLoader classLoader2 = classLoaderHelper.getParent(classLoader);
        if (classLoader2 == null) {
            throw new IllegalArgumentException("The parent of 'target' is null");
        }
        if (classLoader instanceof InjectorClassLoader || classLoader2 instanceof InjectorClassLoader) {
            throw new IllegalArgumentException("'target' has already been injected");
        }
        classLoaderHelper.setParent(classLoader, this.injectorClassLoaderFactory.newInjectorClassLoader(classLoader2, this.source, classLoader));
    }
}

