/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import android.app.Instrumentation;
import android.content.Context;
import android.support.annotation.NonNull;
import com.github.tmurakami.dexopener.AndroidClassSourceFactory;
import com.github.tmurakami.dexopener.ClassInjectorFactory;
import com.github.tmurakami.dexopener.ClassNameFilter;
import com.github.tmurakami.dexopener.DexOpenerImpl;

public abstract class DexOpener {
    DexOpener() {
    }

    public static void install(@NonNull Instrumentation instrumentation) {
        Context context = instrumentation.getTargetContext();
        if (context == null) {
            throw new IllegalArgumentException("'instrumentation' has not yet been initialized");
        }
        DexOpener.builder(context).build().installTo(context.getClassLoader());
    }

    public abstract void installTo(@NonNull ClassLoader var1);

    @NonNull
    public static Builder builder(@NonNull Context context) {
        return new Builder(context);
    }

    public static final class Builder {
        private final Context context;
        private String packageToBeOpened;

        private Builder(Context context) {
            this.context = context;
        }

        @NonNull
        public Builder buildConfig(@NonNull Class<?> buildConfigClass) {
            String applicationId = null;
            if (buildConfigClass.getSimpleName().equals("BuildConfig")) {
                try {
                    applicationId = (String)buildConfigClass.getField("APPLICATION_ID").get(null);
                }
                catch (NoSuchFieldException noSuchFieldException) {
                }
                catch (IllegalAccessException illegalAccessException) {
                    // empty catch block
                }
            }
            String packageToBeOpened = null;
            if (this.context.getPackageName().equals(applicationId)) {
                packageToBeOpened = Builder.retrievePackageName(buildConfigClass);
            }
            if (packageToBeOpened == null || packageToBeOpened.isEmpty()) {
                throw new IllegalArgumentException("'buildConfigClass' must be the BuildConfig class for the target application");
            }
            this.packageToBeOpened = packageToBeOpened;
            return this;
        }

        @NonNull
        public DexOpener build() {
            String packageToBeOpened = this.packageToBeOpened;
            if (packageToBeOpened == null) {
                Class<?> buildConfigClass = Builder.loadBuildConfigClass(this.context);
                packageToBeOpened = this.packageToBeOpened = Builder.retrievePackageName(buildConfigClass);
            }
            ClassNameFilter filter = new ClassNameFilter(packageToBeOpened + '.');
            AndroidClassSourceFactory classSourceFactory = new AndroidClassSourceFactory(filter);
            return new DexOpenerImpl(this.context, classSourceFactory, new ClassInjectorFactory());
        }

        private static String retrievePackageName(Class<?> c) {
            String className = c.getName();
            return className.substring(0, className.lastIndexOf(46));
        }

        private static Class<?> loadBuildConfigClass(Context context) {
            ClassLoader loader = context.getClassLoader();
            String name = context.getPackageName() + ".BuildConfig";
            try {
                return loader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("The BuildConfig for the target application could not be found.\nYou need to put an AndroidJUnitRunner subclass like below in the instrumented tests directory and specify it as the default test instrumentation runner in the project's build.gradle.\n\npublic class YourAndroidJUnitRunner extends AndroidJUnitRunner {\n    @Override\n    public Application newApplication(ClassLoader cl, String className, Context context)\n            throws InstantiationException, IllegalAccessException, ClassNotFoundException {\n        DexOpener.builder(context)\n                 .buildConfig(target.application.BuildConfig.class) // Set the BuildConfig class\n                 .build()\n                 .installTo(cl);\n        return super.newApplication(cl, className, context);\n    }\n}");
            }
        }
    }
}

