/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

final class ClassNameFilter {
    private static final String[] INCLUDED_PACKAGES = new String[]{"android.databinding.generated."};
    private static final String[] INCLUDED_CLASSES = new String[]{"android.databinding.DataBinderMapper", "android.databinding.DataBindingComponent", "android.databinding.DataBindingUtil"};
    private static final String[] EXCLUDED_PACKAGES = new String[]{"android.", "com.android.", "com.github.tmurakami.classinjector.", "com.github.tmurakami.dexmockito.", "com.github.tmurakami.dexopener.", "com.github.tmurakami.mockito4k.", "dalvik.", "java.", "javax.", "junit.", "junitparams.", "kotlin.", "kotlinx.", "net.bytebuddy.", "org.apache.http.", "org.hamcrest.", "org.jacoco.", "org.json.", "org.junit.", "org.mockito.", "org.objenesis.", "org.w3c.dom.", "org.xml.sax.", "org.xmlpull.v1."};
    private final String packagePrefix;

    ClassNameFilter(String packagePrefix) {
        this.packagePrefix = packagePrefix;
    }

    boolean accept(String className) {
        for (String pkg : INCLUDED_PACKAGES) {
            if (!className.startsWith(pkg)) continue;
            return true;
        }
        for (String cls : INCLUDED_CLASSES) {
            if (!className.equals(cls)) continue;
            return true;
        }
        for (String pkg : EXCLUDED_PACKAGES) {
            if (!className.startsWith(pkg)) continue;
            return false;
        }
        return !className.endsWith(".R") && !className.contains(".R$") && !className.endsWith(".BuildConfig") && !className.endsWith(".BR") && className.startsWith(this.packagePrefix);
    }
}

