/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer;

import com.github.tmurakami.dexopener.repackaged.org.jf.util.ExceptionWithContext;
import java.io.BufferedOutputStream;
import java.io.IOException;
import java.io.OutputStream;

public class DexDataWriter
extends BufferedOutputStream {
    private int filePosition;
    private byte[] tempBuf = new byte[8];
    private byte[] zeroBuf = new byte[3];

    public DexDataWriter(OutputStream outputStream, int n) {
        this(outputStream, n, 262144);
    }

    public DexDataWriter(OutputStream outputStream, int n, int n2) {
        super(outputStream, n2);
        this.filePosition = n;
    }

    @Override
    public void write(int n) throws IOException {
        ++this.filePosition;
        super.write(n);
    }

    @Override
    public void write(byte[] byArray) throws IOException {
        this.write(byArray, 0, byArray.length);
    }

    @Override
    public void write(byte[] byArray, int n, int n2) throws IOException {
        this.filePosition += n2;
        super.write(byArray, n, n2);
    }

    public void writeLong(long l) throws IOException {
        this.writeInt((int)l);
        this.writeInt((int)(l >> 32));
    }

    public static void writeInt(OutputStream outputStream, int n) throws IOException {
        outputStream.write(n);
        outputStream.write(n >> 8);
        outputStream.write(n >> 16);
        outputStream.write(n >> 24);
    }

    public void writeInt(int n) throws IOException {
        DexDataWriter.writeInt(this, n);
    }

    public void writeShort(int n) throws IOException {
        if (n < Short.MIN_VALUE || n > Short.MAX_VALUE) {
            throw new ExceptionWithContext("Short value out of range: %d", n);
        }
        this.write(n);
        this.write(n >> 8);
    }

    public void writeUshort(int n) throws IOException {
        if (n < 0 || n > 65535) {
            throw new ExceptionWithContext("Unsigned short value out of range: %d", n);
        }
        this.write(n);
        this.write(n >> 8);
    }

    public void writeUbyte(int n) throws IOException {
        if (n < 0 || n > 255) {
            throw new ExceptionWithContext("Unsigned byte value out of range: %d", n);
        }
        this.write(n);
    }

    public static void writeUleb128(OutputStream outputStream, int n) throws IOException {
        while (n > 127) {
            outputStream.write(n & 0x7F | 0x80);
            n >>>= 7;
        }
        outputStream.write(n);
    }

    public void writeUleb128(int n) throws IOException {
        DexDataWriter.writeUleb128(this, n);
    }

    public static void writeSleb128(OutputStream outputStream, int n) throws IOException {
        if (n >= 0) {
            while (n > 63) {
                outputStream.write(n & 0x7F | 0x80);
                n >>>= 7;
            }
            outputStream.write(n & 0x7F);
        } else {
            while (n < -64) {
                outputStream.write(n & 0x7F | 0x80);
                n >>= 7;
            }
            outputStream.write(n & 0x7F);
        }
    }

    public void writeSleb128(int n) throws IOException {
        DexDataWriter.writeSleb128(this, n);
    }

    public void writeEncodedValueHeader(int n, int n2) throws IOException {
        this.write(n | n2 << 5);
    }

    public void writeEncodedInt(int n, int n2) throws IOException {
        int n3 = 0;
        if (n2 >= 0) {
            while (n2 > 127) {
                this.tempBuf[n3++] = (byte)n2;
                n2 >>= 8;
            }
        } else {
            while (n2 < -128) {
                this.tempBuf[n3++] = (byte)n2;
                n2 >>= 8;
            }
        }
        this.tempBuf[n3++] = (byte)n2;
        this.writeEncodedValueHeader(n, n3 - 1);
        this.write(this.tempBuf, 0, n3);
    }

    public void writeEncodedLong(int n, long l) throws IOException {
        int n2 = 0;
        if (l >= 0L) {
            while (l > 127L) {
                this.tempBuf[n2++] = (byte)l;
                l >>= 8;
            }
        } else {
            while (l < -128L) {
                this.tempBuf[n2++] = (byte)l;
                l >>= 8;
            }
        }
        this.tempBuf[n2++] = (byte)l;
        this.writeEncodedValueHeader(n, n2 - 1);
        this.write(this.tempBuf, 0, n2);
    }

    public void writeEncodedUint(int n, int n2) throws IOException {
        int n3 = 0;
        do {
            this.tempBuf[n3++] = (byte)n2;
        } while ((n2 >>>= 8) != 0);
        this.writeEncodedValueHeader(n, n3 - 1);
        this.write(this.tempBuf, 0, n3);
    }

    public void writeEncodedFloat(int n, float f) throws IOException {
        this.writeRightZeroExtendedInt(n, Float.floatToRawIntBits(f));
    }

    protected void writeRightZeroExtendedInt(int n, int n2) throws IOException {
        int n3 = 3;
        do {
            this.tempBuf[n3--] = (byte)((n2 & 0xFF000000) >>> 24);
        } while ((n2 <<= 8) != 0);
        int n4 = n3 + 1;
        int n5 = 4 - n4;
        this.writeEncodedValueHeader(n, n5 - 1);
        this.write(this.tempBuf, n4, n5);
    }

    public void writeEncodedDouble(int n, double d) throws IOException {
        this.writeRightZeroExtendedLong(n, Double.doubleToRawLongBits(d));
    }

    protected void writeRightZeroExtendedLong(int n, long l) throws IOException {
        int n2 = 7;
        do {
            this.tempBuf[n2--] = (byte)((l & 0xFF00000000000000L) >>> 56);
        } while ((l <<= 8) != 0L);
        int n3 = n2 + 1;
        int n4 = 8 - n3;
        this.writeEncodedValueHeader(n, n4 - 1);
        this.write(this.tempBuf, n3, n4);
    }

    public void writeString(String string) throws IOException {
        int n = string.length();
        if (this.tempBuf.length <= string.length() * 3) {
            this.tempBuf = new byte[string.length() * 3];
        }
        byte[] byArray = this.tempBuf;
        int n2 = 0;
        for (int i = 0; i < n; ++i) {
            char c = string.charAt(i);
            if (c != '\u0000' && c < '\u0080') {
                byArray[n2++] = (byte)c;
                continue;
            }
            if (c < '\u0800') {
                byArray[n2++] = (byte)(c >> 6 & 0x1F | 0xC0);
                byArray[n2++] = (byte)(c & 0x3F | 0x80);
                continue;
            }
            byArray[n2++] = (byte)(c >> 12 & 0xF | 0xE0);
            byArray[n2++] = (byte)(c >> 6 & 0x3F | 0x80);
            byArray[n2++] = (byte)(c & 0x3F | 0x80);
        }
        this.write(byArray, 0, n2);
    }

    public void align() throws IOException {
        int n = -this.getPosition() & 3;
        if (n > 0) {
            this.write(this.zeroBuf, 0, n);
        }
    }

    public int getPosition() {
        return this.filePosition;
    }
}

