/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.util;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexReader;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.value.DexBackedEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.EncodedValue;

public abstract class StaticInitialValueIterator {
    public static final StaticInitialValueIterator EMPTY = new StaticInitialValueIterator(){

        @Override
        public EncodedValue getNextOrNull() {
            return null;
        }

        @Override
        public int getReaderOffset() {
            return 0;
        }
    };

    public abstract EncodedValue getNextOrNull();

    public abstract int getReaderOffset();

    public static StaticInitialValueIterator newOrEmpty(DexBackedDexFile dexBackedDexFile, int n) {
        if (n == 0) {
            return EMPTY;
        }
        return new StaticInitialValueIteratorImpl(dexBackedDexFile, n);
    }

    private static class StaticInitialValueIteratorImpl
    extends StaticInitialValueIterator {
        private final DexReader reader;
        private final int size;
        private int index = 0;

        public StaticInitialValueIteratorImpl(DexBackedDexFile dexBackedDexFile, int n) {
            this.reader = dexBackedDexFile.readerAt(n);
            this.size = this.reader.readSmallUleb128();
        }

        @Override
        public EncodedValue getNextOrNull() {
            if (this.index < this.size) {
                ++this.index;
                return DexBackedEncodedValue.readFrom(this.reader);
            }
            return null;
        }

        @Override
        public int getReaderOffset() {
            return this.reader.getOffset();
        }
    }
}

