/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import android.app.Instrumentation;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.support.annotation.NonNull;
import com.github.tmurakami.dexopener.AndroidClassSourceFactory;
import com.github.tmurakami.dexopener.ClassInjectorFactory;
import com.github.tmurakami.dexopener.ClassNameFilter;
import com.github.tmurakami.dexopener.FileUtils;
import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.ClassSource;
import java.io.File;

public final class DexOpener {
    private final Context context;
    private final AndroidClassSourceFactory androidClassSourceFactory;
    private final ClassInjectorFactory classInjectorFactory;

    DexOpener(Context context, AndroidClassSourceFactory androidClassSourceFactory, ClassInjectorFactory classInjectorFactory) {
        this.context = context;
        this.androidClassSourceFactory = androidClassSourceFactory;
        this.classInjectorFactory = classInjectorFactory;
    }

    public static void install(@NonNull Instrumentation instrumentation) {
        Context context = instrumentation.getTargetContext();
        if (context == null) {
            throw new IllegalArgumentException("'instrumentation' has not yet been initialized");
        }
        DexOpener.builder(context).build().installTo(context.getClassLoader());
    }

    public void installTo(@NonNull ClassLoader target) {
        Context context = this.context;
        ApplicationInfo ai = context.getApplicationInfo();
        if (Build.VERSION.SDK_INT >= 24 && ai.minSdkVersion >= 26) {
            throw new UnsupportedOperationException("minSdkVersion must be lower than 26");
        }
        if (context.getApplicationContext() != null) {
            throw new IllegalStateException("This method must be called before the Application instance is created");
        }
        File cacheDir = new File(ai.dataDir, "code_cache/dexopener");
        if (cacheDir.isDirectory()) {
            FileUtils.delete(cacheDir.listFiles());
        }
        ClassSource classSource = this.androidClassSourceFactory.newClassSource(ai.sourceDir, cacheDir);
        this.classInjectorFactory.newClassInjector(classSource).into(target);
    }

    @NonNull
    public static Builder builder(@NonNull Context context) {
        return new Builder(context);
    }

    public static final class Builder {
        private final Context context;
        private Class<?> buildConfigClass;

        private Builder(Context context) {
            this.context = context;
        }

        @NonNull
        public Builder buildConfig(@NonNull Class<?> buildConfigClass) {
            String applicationId = null;
            try {
                applicationId = (String)buildConfigClass.getField("APPLICATION_ID").get(null);
            }
            catch (NoSuchFieldException noSuchFieldException) {
            }
            catch (IllegalAccessException illegalAccessException) {
                // empty catch block
            }
            if (!this.context.getPackageName().equals(applicationId)) {
                throw new IllegalArgumentException("'buildConfigClass' must be the BuildConfig class for the target application");
            }
            this.buildConfigClass = buildConfigClass;
            return this;
        }

        @NonNull
        public DexOpener build() {
            if (this.buildConfigClass == null) {
                this.buildConfigClass = this.loadBuildConfigClass();
            }
            return new DexOpener(this.context, this.newAndroidClassSourceFactory(), new ClassInjectorFactory());
        }

        private Class<?> loadBuildConfigClass() {
            ClassLoader loader = this.context.getClassLoader();
            String name = this.context.getPackageName() + ".BuildConfig";
            try {
                return loader.loadClass(name);
            }
            catch (ClassNotFoundException e) {
                throw new IllegalStateException("The BuildConfig for the target application could not be found.\nYou need to put an AndroidJUnitRunner subclass like below in the instrumented tests directory and specify it as the default test instrumentation runner in the project's build.gradle.\n\npublic class YourAndroidJUnitRunner extends AndroidJUnitRunner {\n    @Override\n    public Application newApplication(ClassLoader cl, String className, Context context)\n            throws InstantiationException, IllegalAccessException, ClassNotFoundException {\n        DexOpener.builder(context)\n                 .buildConfig(target.application.BuildConfig.class) // Set the BuildConfig class\n                 .build()\n                 .installTo(cl);\n        return super.newApplication(cl, className, context);\n    }\n}");
            }
        }

        private AndroidClassSourceFactory newAndroidClassSourceFactory() {
            Class<?> buildConfigClass = this.buildConfigClass;
            String className = buildConfigClass.getName();
            String simpleName = buildConfigClass.getSimpleName();
            String packagePrefix = className.substring(0, className.lastIndexOf(simpleName));
            return new AndroidClassSourceFactory(new ClassNameFilter(packagePrefix));
        }
    }
}

