/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import com.github.tmurakami.dexopener.DexFileLoader;
import com.github.tmurakami.dexopener.FileUtils;
import com.github.tmurakami.dexopener.Loggers;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.DexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.rewriter.DexRewriter;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.io.DexDataStore;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.io.FileDataStore;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.DexPool;
import java.io.File;
import java.io.IOException;
import java.util.concurrent.Callable;
import java.util.logging.Level;
import java.util.logging.Logger;

final class DexFileTask
implements Callable<dalvik.system.DexFile> {
    private DexFile dexFile;
    private final DexRewriter dexRewriter;
    private final File cacheDir;
    private final DexFileLoader dexFileLoader;

    DexFileTask(DexFile dexFile, DexRewriter dexRewriter, File cacheDir, DexFileLoader dexFileLoader) {
        this.dexFile = dexFile;
        this.dexRewriter = dexRewriter;
        this.cacheDir = cacheDir;
        this.dexFileLoader = dexFileLoader;
    }

    @Override
    public dalvik.system.DexFile call() throws IOException {
        try {
            dalvik.system.DexFile dexFile = this.generateDex(this.dexRewriter.rewriteDexFile(this.dexFile));
            return dexFile;
        }
        finally {
            this.dexFile = null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private dalvik.system.DexFile generateDex(DexFile dexFile) throws IOException {
        dalvik.system.DexFile file;
        File cacheDir = this.cacheDir;
        if (!cacheDir.isDirectory() && !cacheDir.mkdirs()) {
            throw new IOException("Cannot create " + cacheDir);
        }
        File dex = File.createTempFile("classes", ".dex", cacheDir);
        File tmp = new File(cacheDir, dex.getName() + ".tmp.dex");
        String dexPath = dex.getCanonicalPath();
        try {
            DexPool.writeTo((DexDataStore)new FileDataStore(tmp), (DexFile)dexFile);
            file = this.dexFileLoader.loadDex(tmp.getCanonicalPath(), dexPath, 0);
        }
        catch (Throwable throwable) {
            FileUtils.delete(tmp);
            throw throwable;
        }
        FileUtils.delete(tmp);
        Logger logger = Loggers.get();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("DEX file generated: " + dexPath);
        }
        return file;
    }
}

