/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import android.app.Instrumentation;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.os.Build;
import android.support.annotation.NonNull;
import com.github.tmurakami.dexopener.AndroidClassSourceFactory;
import com.github.tmurakami.dexopener.ClassInjectorFactory;
import com.github.tmurakami.dexopener.ClassNameFilter;
import com.github.tmurakami.dexopener.ClassNameFilterWrapper;
import com.github.tmurakami.dexopener.FileUtils;
import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.ClassSource;
import java.io.File;
import java.lang.reflect.Field;

public final class DexOpener {
    private final Context context;
    private final AndroidClassSourceFactory androidClassSourceFactory;
    private final ClassInjectorFactory classInjectorFactory;

    DexOpener(Context context, AndroidClassSourceFactory androidClassSourceFactory, ClassInjectorFactory classInjectorFactory) {
        this.context = context;
        this.androidClassSourceFactory = androidClassSourceFactory;
        this.classInjectorFactory = classInjectorFactory;
    }

    public static void install(@NonNull Instrumentation instrumentation) {
        Context context = instrumentation.getTargetContext();
        if (context == null) {
            throw new IllegalArgumentException("'instrumentation' has not yet been initialized");
        }
        DexOpener.builder(context).build().installTo(context.getClassLoader());
    }

    public void installTo(@NonNull ClassLoader target) {
        Context context = this.context;
        ApplicationInfo ai = context.getApplicationInfo();
        if (Build.VERSION.SDK_INT >= 24 && ai.minSdkVersion >= 26) {
            throw new UnsupportedOperationException("minSdkVersion must be lower than 26");
        }
        if (context.getApplicationContext() != null) {
            throw new IllegalStateException("This method must be called before the Application instance is created");
        }
        File cacheDir = new File(ai.dataDir, "code_cache/dexopener");
        if (cacheDir.isDirectory()) {
            FileUtils.delete(cacheDir.listFiles());
        }
        ClassSource classSource = this.androidClassSourceFactory.newClassSource(ai.sourceDir, cacheDir);
        this.classInjectorFactory.newClassInjector(classSource).into(target);
    }

    @NonNull
    public static Builder builder(@NonNull Context context) {
        return new Builder(context);
    }

    public static final class Builder {
        private final Context context;
        private ClassNameFilter classNameFilter;

        private Builder(Context context) {
            this.context = context;
        }

        @Deprecated
        @NonNull
        public Builder openIf(@NonNull ClassNameFilter filter) {
            return this.classNameFilter(filter);
        }

        @Deprecated
        @NonNull
        public Builder classNameFilter(@NonNull ClassNameFilter filter) {
            this.classNameFilter = filter;
            return this;
        }

        @NonNull
        public Builder buildConfig(@NonNull Class<?> buildConfigClass) {
            String applicationId = null;
            try {
                Field field = buildConfigClass.getField("APPLICATION_ID");
                applicationId = (String)field.get(null);
            }
            catch (NoSuchFieldException field) {
            }
            catch (IllegalAccessException e) {
                throw new IllegalStateException(e.getMessage(), e);
            }
            if (!this.context.getPackageName().equals(applicationId)) {
                throw new IllegalArgumentException("'buildConfigClass' must be your app's BuildConfig.class");
            }
            String className = buildConfigClass.getName();
            String simpleName = buildConfigClass.getSimpleName();
            final String packagePrefix = className.substring(0, className.lastIndexOf(simpleName));
            this.classNameFilter = new ClassNameFilter(){

                @Override
                public boolean accept(@NonNull String className) {
                    return className.startsWith(packagePrefix);
                }
            };
            return this;
        }

        @NonNull
        public DexOpener build() {
            ClassNameFilterWrapper classNameFilter = new ClassNameFilterWrapper(this.getClassNameFilter());
            return new DexOpener(this.context, new AndroidClassSourceFactory(classNameFilter), new ClassInjectorFactory());
        }

        private ClassNameFilter getClassNameFilter() {
            if (this.classNameFilter == null) {
                Context context = this.context;
                String buildConfigName = context.getPackageName() + ".BuildConfig";
                ClassLoader loader = context.getClassLoader();
                try {
                    this.buildConfig(loader.loadClass(buildConfigName));
                }
                catch (ClassNotFoundException e) {
                    throw new IllegalStateException("BuildConfig.class must be set by DexOpener.Builder#buildConfig(Class)");
                }
            }
            return this.classNameFilter;
        }
    }
}

