/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import com.github.tmurakami.dexopener.DexFileHolder;
import dalvik.system.DexFile;
import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.FutureTask;

final class DexFileHolderImpl
implements DexFileHolder {
    private FutureTask<DexFile> task;

    DexFileHolderImpl() {
    }

    void setTask(FutureTask<DexFile> task) {
        this.task = task;
    }

    @Override
    public DexFile get() throws IOException {
        this.task.run();
        boolean interrupted = false;
        while (true) {
            try {
                DexFile dexFile = this.task.get();
                return dexFile;
            }
            catch (InterruptedException e) {
                try {
                    interrupted = true;
                    continue;
                }
                catch (ExecutionException e2) {
                    Throwable cause = e2.getCause();
                    if (cause instanceof IOException) {
                        throw (IOException)cause;
                    }
                    if (cause instanceof RuntimeException) {
                        throw (RuntimeException)cause;
                    }
                    if (cause instanceof Error) {
                        throw (Error)cause;
                    }
                    throw new UndeclaredThrowableException(e2, "Unexpected error");
                }
            }
            break;
        }
        finally {
            if (interrupted) {
                Thread.currentThread().interrupt();
            }
        }
    }
}

