/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import android.support.annotation.NonNull;
import com.github.tmurakami.dexopener.ClassNameFilter;

final class ClassNameFilterWrapper
implements ClassNameFilter {
    private static final String[] INCLUDED_PACKAGES = new String[]{"android.databinding.generated."};
    private static final String[] INCLUDED_CLASSES = new String[]{"android.databinding.DataBinderMapper", "android.databinding.DataBindingComponent", "android.databinding.DataBindingUtil"};
    private static final String[] EXCLUDED_PACKAGES = new String[]{"android.", "com.android.", "com.github.tmurakami.classinjector.", "com.github.tmurakami.dexmockito.", "com.github.tmurakami.dexopener.", "com.github.tmurakami.mockito4k.", "java.", "javax.", "junit.", "kotlin.", "kotlinx.", "net.bytebuddy.", "org.hamcrest.", "org.jacoco.", "org.junit.", "org.mockito.", "org.objenesis."};
    private final ClassNameFilter delegate;

    ClassNameFilterWrapper(ClassNameFilter delegate) {
        this.delegate = delegate;
    }

    @Override
    public boolean accept(@NonNull String className) {
        for (String pkg : INCLUDED_PACKAGES) {
            if (!className.startsWith(pkg)) continue;
            return true;
        }
        for (String cls : INCLUDED_CLASSES) {
            if (!className.equals(cls)) continue;
            return true;
        }
        for (String pkg : EXCLUDED_PACKAGES) {
            if (!className.startsWith(pkg)) continue;
            return false;
        }
        return !className.endsWith(".R") && !className.contains(".R$") && !className.endsWith(".BuildConfig") && !className.endsWith(".BR") && this.delegate.accept(className);
    }
}

