/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.rewriter;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Iterators;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.base.reference.BaseTypeReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Annotation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.ClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Field;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Method;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.rewriter.Rewriter;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.rewriter.RewriterUtils;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.rewriter.Rewriters;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class ClassDefRewriter
implements Rewriter<ClassDef> {
    protected final Rewriters rewriters;

    public ClassDefRewriter(Rewriters rewriters) {
        this.rewriters = rewriters;
    }

    @Override
    public ClassDef rewrite(ClassDef classDef) {
        return new RewrittenClassDef(classDef);
    }

    protected class RewrittenClassDef
    extends BaseTypeReference
    implements ClassDef {
        protected ClassDef classDef;

        public RewrittenClassDef(ClassDef classDef) {
            this.classDef = classDef;
        }

        @Override
        public String getType() {
            return ClassDefRewriter.this.rewriters.getTypeRewriter().rewrite(this.classDef.getType());
        }

        @Override
        public int getAccessFlags() {
            return this.classDef.getAccessFlags();
        }

        @Override
        public String getSuperclass() {
            return RewriterUtils.rewriteNullable(ClassDefRewriter.this.rewriters.getTypeRewriter(), this.classDef.getSuperclass());
        }

        @Override
        public List<String> getInterfaces() {
            return RewriterUtils.rewriteList(ClassDefRewriter.this.rewriters.getTypeRewriter(), this.classDef.getInterfaces());
        }

        @Override
        public String getSourceFile() {
            return this.classDef.getSourceFile();
        }

        @Override
        public Set<? extends Annotation> getAnnotations() {
            return RewriterUtils.rewriteSet(ClassDefRewriter.this.rewriters.getAnnotationRewriter(), this.classDef.getAnnotations());
        }

        @Override
        public Iterable<? extends Field> getStaticFields() {
            return RewriterUtils.rewriteIterable(ClassDefRewriter.this.rewriters.getFieldRewriter(), this.classDef.getStaticFields());
        }

        @Override
        public Iterable<? extends Field> getInstanceFields() {
            return RewriterUtils.rewriteIterable(ClassDefRewriter.this.rewriters.getFieldRewriter(), this.classDef.getInstanceFields());
        }

        @Override
        public Iterable<? extends Method> getDirectMethods() {
            return RewriterUtils.rewriteIterable(ClassDefRewriter.this.rewriters.getMethodRewriter(), this.classDef.getDirectMethods());
        }

        @Override
        public Iterable<? extends Method> getVirtualMethods() {
            return RewriterUtils.rewriteIterable(ClassDefRewriter.this.rewriters.getMethodRewriter(), this.classDef.getVirtualMethods());
        }

        @Override
        public Iterable<? extends Method> getMethods() {
            return new Iterable<Method>(){

                @Override
                public Iterator<Method> iterator() {
                    return Iterators.concat(RewrittenClassDef.this.getDirectMethods().iterator(), RewrittenClassDef.this.getVirtualMethods().iterator());
                }
            };
        }
    }
}

