/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.instruction;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Format;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcode;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction21ih;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.instruction.ImmutableInstruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.util.Preconditions;

public class ImmutableInstruction21ih
extends ImmutableInstruction
implements Instruction21ih {
    public static final Format FORMAT = Format.Format21ih;
    protected final int registerA;
    protected final int literal;

    public ImmutableInstruction21ih(Opcode opcode, int n, int n2) {
        super(opcode);
        this.registerA = Preconditions.checkByteRegister(n);
        this.literal = Preconditions.checkIntegerHatLiteral(n2);
    }

    public static ImmutableInstruction21ih of(Instruction21ih instruction21ih) {
        if (instruction21ih instanceof ImmutableInstruction21ih) {
            return (ImmutableInstruction21ih)instruction21ih;
        }
        return new ImmutableInstruction21ih(instruction21ih.getOpcode(), instruction21ih.getRegisterA(), instruction21ih.getNarrowLiteral());
    }

    @Override
    public int getRegisterA() {
        return this.registerA;
    }

    @Override
    public int getNarrowLiteral() {
        return this.literal;
    }

    @Override
    public long getWideLiteral() {
        return this.literal;
    }

    @Override
    public short getHatLiteral() {
        return (short)(this.literal >>> 16);
    }

    @Override
    public Format getFormat() {
        return FORMAT;
    }
}

