/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer;

import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.Ordering;
import com.github.tmurakami.dexopener.repackaged.com.google.common.primitives.Ints;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcode;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcodes;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.DualReferenceInstruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.ReferenceInstruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.SwitchElement;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.ArrayPayload;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction10t;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction10x;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction11n;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction11x;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction12x;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction20bc;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction20t;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction21c;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction21ih;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction21lh;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction21s;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction21t;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction22b;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction22c;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction22cs;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction22s;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction22t;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction22x;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction23x;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction30t;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction31c;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction31i;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction31t;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction32x;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction35c;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction35mi;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction35ms;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction3rc;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction3rmi;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction3rms;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction45cc;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction4rcc;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction51l;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.PackedSwitchPayload;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.SparseSwitchPayload;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.FieldReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.MethodProtoReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.MethodReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.Reference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.StringReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.TypeReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.DexDataWriter;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.FieldSection;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.MethodSection;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.ProtoSection;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.StringSection;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.TypeSection;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.ExceptionWithContext;
import java.io.IOException;
import java.util.Comparator;
import java.util.List;

public class InstructionWriter<StringRef extends StringReference, TypeRef extends TypeReference, FieldRefKey extends FieldReference, MethodRefKey extends MethodReference, ProtoRefKey extends MethodProtoReference> {
    private final Opcodes opcodes;
    private final DexDataWriter writer;
    private final StringSection<?, StringRef> stringSection;
    private final TypeSection<?, ?, TypeRef> typeSection;
    private final FieldSection<?, ?, FieldRefKey, ?> fieldSection;
    private final MethodSection<?, ?, ?, MethodRefKey, ?> methodSection;
    private final ProtoSection<?, ?, ProtoRefKey, ?> protoSection;
    private final Comparator<SwitchElement> switchElementComparator = new Comparator<SwitchElement>(){

        @Override
        public int compare(SwitchElement switchElement, SwitchElement switchElement2) {
            return Ints.compare(switchElement.getKey(), switchElement2.getKey());
        }
    };

    static <StringRef extends StringReference, TypeRef extends TypeReference, FieldRefKey extends FieldReference, MethodRefKey extends MethodReference, ProtoRefKey extends MethodProtoReference> InstructionWriter<StringRef, TypeRef, FieldRefKey, MethodRefKey, ProtoRefKey> makeInstructionWriter(Opcodes opcodes, DexDataWriter dexDataWriter, StringSection<?, StringRef> stringSection, TypeSection<?, ?, TypeRef> typeSection, FieldSection<?, ?, FieldRefKey, ?> fieldSection, MethodSection<?, ?, ?, MethodRefKey, ?> methodSection, ProtoSection<?, ?, ProtoRefKey, ?> protoSection) {
        return new InstructionWriter<StringRef, TypeRef, FieldRefKey, MethodRefKey, ProtoRefKey>(opcodes, dexDataWriter, stringSection, typeSection, fieldSection, methodSection, protoSection);
    }

    InstructionWriter(Opcodes opcodes, DexDataWriter dexDataWriter, StringSection<?, StringRef> stringSection, TypeSection<?, ?, TypeRef> typeSection, FieldSection<?, ?, FieldRefKey, ?> fieldSection, MethodSection<?, ?, ?, MethodRefKey, ?> methodSection, ProtoSection<?, ?, ProtoRefKey, ?> protoSection) {
        this.opcodes = opcodes;
        this.writer = dexDataWriter;
        this.stringSection = stringSection;
        this.typeSection = typeSection;
        this.fieldSection = fieldSection;
        this.methodSection = methodSection;
        this.protoSection = protoSection;
    }

    private short getOpcodeValue(Opcode opcode) {
        Short s = this.opcodes.getOpcodeValue(opcode);
        if (s == null) {
            throw new ExceptionWithContext("Instruction %s is invalid for api %d", opcode.name, this.opcodes.api);
        }
        return s;
    }

    public void write(Instruction10t instruction10t) {
        try {
            this.writer.write(this.getOpcodeValue(instruction10t.getOpcode()));
            this.writer.write(instruction10t.getCodeOffset());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(Instruction10x instruction10x) {
        try {
            this.writer.write(this.getOpcodeValue(instruction10x.getOpcode()));
            this.writer.write(0);
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(Instruction11n instruction11n) {
        try {
            this.writer.write(this.getOpcodeValue(instruction11n.getOpcode()));
            this.writer.write(InstructionWriter.packNibbles(instruction11n.getRegisterA(), instruction11n.getNarrowLiteral()));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(Instruction11x instruction11x) {
        try {
            this.writer.write(this.getOpcodeValue(instruction11x.getOpcode()));
            this.writer.write(instruction11x.getRegisterA());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(Instruction12x instruction12x) {
        try {
            this.writer.write(this.getOpcodeValue(instruction12x.getOpcode()));
            this.writer.write(InstructionWriter.packNibbles(instruction12x.getRegisterA(), instruction12x.getRegisterB()));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(Instruction20bc instruction20bc) {
        try {
            this.writer.write(this.getOpcodeValue(instruction20bc.getOpcode()));
            this.writer.write(instruction20bc.getVerificationError());
            this.writer.writeUshort(this.getReferenceIndex(instruction20bc));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(Instruction20t instruction20t) {
        try {
            this.writer.write(this.getOpcodeValue(instruction20t.getOpcode()));
            this.writer.write(0);
            this.writer.writeShort(instruction20t.getCodeOffset());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(Instruction21c instruction21c) {
        try {
            this.writer.write(this.getOpcodeValue(instruction21c.getOpcode()));
            this.writer.write(instruction21c.getRegisterA());
            this.writer.writeUshort(this.getReferenceIndex(instruction21c));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(Instruction21ih instruction21ih) {
        try {
            this.writer.write(this.getOpcodeValue(instruction21ih.getOpcode()));
            this.writer.write(instruction21ih.getRegisterA());
            this.writer.writeShort(instruction21ih.getHatLiteral());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(Instruction21lh instruction21lh) {
        try {
            this.writer.write(this.getOpcodeValue(instruction21lh.getOpcode()));
            this.writer.write(instruction21lh.getRegisterA());
            this.writer.writeShort(instruction21lh.getHatLiteral());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(Instruction21s instruction21s) {
        try {
            this.writer.write(this.getOpcodeValue(instruction21s.getOpcode()));
            this.writer.write(instruction21s.getRegisterA());
            this.writer.writeShort(instruction21s.getNarrowLiteral());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(Instruction21t instruction21t) {
        try {
            this.writer.write(this.getOpcodeValue(instruction21t.getOpcode()));
            this.writer.write(instruction21t.getRegisterA());
            this.writer.writeShort(instruction21t.getCodeOffset());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(Instruction22b instruction22b) {
        try {
            this.writer.write(this.getOpcodeValue(instruction22b.getOpcode()));
            this.writer.write(instruction22b.getRegisterA());
            this.writer.write(instruction22b.getRegisterB());
            this.writer.write(instruction22b.getNarrowLiteral());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(Instruction22c instruction22c) {
        try {
            this.writer.write(this.getOpcodeValue(instruction22c.getOpcode()));
            this.writer.write(InstructionWriter.packNibbles(instruction22c.getRegisterA(), instruction22c.getRegisterB()));
            this.writer.writeUshort(this.getReferenceIndex(instruction22c));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(Instruction22cs instruction22cs) {
        try {
            this.writer.write(this.getOpcodeValue(instruction22cs.getOpcode()));
            this.writer.write(InstructionWriter.packNibbles(instruction22cs.getRegisterA(), instruction22cs.getRegisterB()));
            this.writer.writeUshort(instruction22cs.getFieldOffset());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(Instruction22s instruction22s) {
        try {
            this.writer.write(this.getOpcodeValue(instruction22s.getOpcode()));
            this.writer.write(InstructionWriter.packNibbles(instruction22s.getRegisterA(), instruction22s.getRegisterB()));
            this.writer.writeShort(instruction22s.getNarrowLiteral());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(Instruction22t instruction22t) {
        try {
            this.writer.write(this.getOpcodeValue(instruction22t.getOpcode()));
            this.writer.write(InstructionWriter.packNibbles(instruction22t.getRegisterA(), instruction22t.getRegisterB()));
            this.writer.writeShort(instruction22t.getCodeOffset());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(Instruction22x instruction22x) {
        try {
            this.writer.write(this.getOpcodeValue(instruction22x.getOpcode()));
            this.writer.write(instruction22x.getRegisterA());
            this.writer.writeUshort(instruction22x.getRegisterB());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(Instruction23x instruction23x) {
        try {
            this.writer.write(this.getOpcodeValue(instruction23x.getOpcode()));
            this.writer.write(instruction23x.getRegisterA());
            this.writer.write(instruction23x.getRegisterB());
            this.writer.write(instruction23x.getRegisterC());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(Instruction30t instruction30t) {
        try {
            this.writer.write(this.getOpcodeValue(instruction30t.getOpcode()));
            this.writer.write(0);
            this.writer.writeInt(instruction30t.getCodeOffset());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(Instruction31c instruction31c) {
        try {
            this.writer.write(this.getOpcodeValue(instruction31c.getOpcode()));
            this.writer.write(instruction31c.getRegisterA());
            this.writer.writeInt(this.getReferenceIndex(instruction31c));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(Instruction31i instruction31i) {
        try {
            this.writer.write(this.getOpcodeValue(instruction31i.getOpcode()));
            this.writer.write(instruction31i.getRegisterA());
            this.writer.writeInt(instruction31i.getNarrowLiteral());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(Instruction31t instruction31t) {
        try {
            this.writer.write(this.getOpcodeValue(instruction31t.getOpcode()));
            this.writer.write(instruction31t.getRegisterA());
            this.writer.writeInt(instruction31t.getCodeOffset());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(Instruction32x instruction32x) {
        try {
            this.writer.write(this.getOpcodeValue(instruction32x.getOpcode()));
            this.writer.write(0);
            this.writer.writeUshort(instruction32x.getRegisterA());
            this.writer.writeUshort(instruction32x.getRegisterB());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(Instruction35c instruction35c) {
        try {
            this.writer.write(this.getOpcodeValue(instruction35c.getOpcode()));
            this.writer.write(InstructionWriter.packNibbles(instruction35c.getRegisterG(), instruction35c.getRegisterCount()));
            this.writer.writeUshort(this.getReferenceIndex(instruction35c));
            this.writer.write(InstructionWriter.packNibbles(instruction35c.getRegisterC(), instruction35c.getRegisterD()));
            this.writer.write(InstructionWriter.packNibbles(instruction35c.getRegisterE(), instruction35c.getRegisterF()));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(Instruction35mi instruction35mi) {
        try {
            this.writer.write(this.getOpcodeValue(instruction35mi.getOpcode()));
            this.writer.write(InstructionWriter.packNibbles(instruction35mi.getRegisterG(), instruction35mi.getRegisterCount()));
            this.writer.writeUshort(instruction35mi.getInlineIndex());
            this.writer.write(InstructionWriter.packNibbles(instruction35mi.getRegisterC(), instruction35mi.getRegisterD()));
            this.writer.write(InstructionWriter.packNibbles(instruction35mi.getRegisterE(), instruction35mi.getRegisterF()));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(Instruction35ms instruction35ms) {
        try {
            this.writer.write(this.getOpcodeValue(instruction35ms.getOpcode()));
            this.writer.write(InstructionWriter.packNibbles(instruction35ms.getRegisterG(), instruction35ms.getRegisterCount()));
            this.writer.writeUshort(instruction35ms.getVtableIndex());
            this.writer.write(InstructionWriter.packNibbles(instruction35ms.getRegisterC(), instruction35ms.getRegisterD()));
            this.writer.write(InstructionWriter.packNibbles(instruction35ms.getRegisterE(), instruction35ms.getRegisterF()));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(Instruction3rc instruction3rc) {
        try {
            this.writer.write(this.getOpcodeValue(instruction3rc.getOpcode()));
            this.writer.write(instruction3rc.getRegisterCount());
            this.writer.writeUshort(this.getReferenceIndex(instruction3rc));
            this.writer.writeUshort(instruction3rc.getStartRegister());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(Instruction3rmi instruction3rmi) {
        try {
            this.writer.write(this.getOpcodeValue(instruction3rmi.getOpcode()));
            this.writer.write(instruction3rmi.getRegisterCount());
            this.writer.writeUshort(instruction3rmi.getInlineIndex());
            this.writer.writeUshort(instruction3rmi.getStartRegister());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(Instruction3rms instruction3rms) {
        try {
            this.writer.write(this.getOpcodeValue(instruction3rms.getOpcode()));
            this.writer.write(instruction3rms.getRegisterCount());
            this.writer.writeUshort(instruction3rms.getVtableIndex());
            this.writer.writeUshort(instruction3rms.getStartRegister());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(Instruction45cc instruction45cc) {
        try {
            this.writer.write(this.getOpcodeValue(instruction45cc.getOpcode()));
            this.writer.write(InstructionWriter.packNibbles(instruction45cc.getRegisterG(), instruction45cc.getRegisterCount()));
            this.writer.writeUshort(this.getReferenceIndex(instruction45cc));
            this.writer.write(InstructionWriter.packNibbles(instruction45cc.getRegisterC(), instruction45cc.getRegisterD()));
            this.writer.write(InstructionWriter.packNibbles(instruction45cc.getRegisterE(), instruction45cc.getRegisterF()));
            this.writer.writeUshort(this.getReference2Index(instruction45cc));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(Instruction4rcc instruction4rcc) {
        try {
            this.writer.write(this.getOpcodeValue(instruction4rcc.getOpcode()));
            this.writer.write(instruction4rcc.getRegisterCount());
            this.writer.writeUshort(this.getReferenceIndex(instruction4rcc));
            this.writer.writeUshort(instruction4rcc.getStartRegister());
            this.writer.writeUshort(this.getReference2Index(instruction4rcc));
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(Instruction51l instruction51l) {
        try {
            this.writer.write(this.getOpcodeValue(instruction51l.getOpcode()));
            this.writer.write(instruction51l.getRegisterA());
            this.writer.writeLong(instruction51l.getWideLiteral());
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(ArrayPayload arrayPayload) {
        try {
            this.writer.writeUshort(this.getOpcodeValue(arrayPayload.getOpcode()));
            this.writer.writeUshort(arrayPayload.getElementWidth());
            List<Number> list = arrayPayload.getArrayElements();
            this.writer.writeInt(list.size());
            switch (arrayPayload.getElementWidth()) {
                case 1: {
                    for (Number number : list) {
                        this.writer.write(number.byteValue());
                    }
                    break;
                }
                case 2: {
                    for (Number number : list) {
                        this.writer.writeShort(number.shortValue());
                    }
                    break;
                }
                case 4: {
                    for (Number number : list) {
                        this.writer.writeInt(number.intValue());
                    }
                    break;
                }
                case 8: {
                    for (Number number : list) {
                        this.writer.writeLong(number.longValue());
                    }
                    break;
                }
            }
            if ((this.writer.getPosition() & 1) != 0) {
                this.writer.write(0);
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(SparseSwitchPayload sparseSwitchPayload) {
        try {
            this.writer.writeUbyte(0);
            this.writer.writeUbyte(this.getOpcodeValue(sparseSwitchPayload.getOpcode()) >> 8);
            ImmutableList<? extends SwitchElement> immutableList = Ordering.from(this.switchElementComparator).immutableSortedCopy(sparseSwitchPayload.getSwitchElements());
            this.writer.writeUshort(immutableList.size());
            for (SwitchElement switchElement : immutableList) {
                this.writer.writeInt(switchElement.getKey());
            }
            for (SwitchElement switchElement : immutableList) {
                this.writer.writeInt(switchElement.getOffset());
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    public void write(PackedSwitchPayload packedSwitchPayload) {
        try {
            this.writer.writeUbyte(0);
            this.writer.writeUbyte(this.getOpcodeValue(packedSwitchPayload.getOpcode()) >> 8);
            List<? extends SwitchElement> list = packedSwitchPayload.getSwitchElements();
            this.writer.writeUshort(list.size());
            if (list.size() == 0) {
                this.writer.writeInt(0);
            } else {
                this.writer.writeInt(list.get(0).getKey());
                for (SwitchElement switchElement : list) {
                    this.writer.writeInt(switchElement.getOffset());
                }
            }
        }
        catch (IOException iOException) {
            throw new RuntimeException(iOException);
        }
    }

    private static int packNibbles(int n, int n2) {
        return n2 << 4 | n;
    }

    private int getReferenceIndex(ReferenceInstruction referenceInstruction) {
        return this.getReferenceIndex(referenceInstruction.getReferenceType(), referenceInstruction.getReference());
    }

    private int getReference2Index(DualReferenceInstruction dualReferenceInstruction) {
        return this.getReferenceIndex(dualReferenceInstruction.getReferenceType2(), dualReferenceInstruction.getReference2());
    }

    private int getReferenceIndex(int n, Reference reference) {
        switch (n) {
            case 2: {
                return this.fieldSection.getItemIndex((FieldReference)reference);
            }
            case 3: {
                return this.methodSection.getItemIndex((MethodReference)reference);
            }
            case 0: {
                return this.stringSection.getItemIndex((StringReference)reference);
            }
            case 1: {
                return this.typeSection.getItemIndex((TypeReference)reference);
            }
            case 4: {
                return this.protoSection.getItemIndex((MethodProtoReference)reference);
            }
        }
        throw new ExceptionWithContext("Unknown reference type: %d", n);
    }
}

