/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.instruction;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Format;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcode;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction31c;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.Reference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.instruction.ImmutableInstruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.reference.ImmutableReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.reference.ImmutableReferenceFactory;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.util.Preconditions;

public class ImmutableInstruction31c
extends ImmutableInstruction
implements Instruction31c {
    public static final Format FORMAT = Format.Format31c;
    protected final int registerA;
    protected final ImmutableReference reference;

    public ImmutableInstruction31c(Opcode opcode, int n, Reference reference) {
        super(opcode);
        this.registerA = Preconditions.checkByteRegister(n);
        this.reference = ImmutableReferenceFactory.of(opcode.referenceType, reference);
    }

    public static ImmutableInstruction31c of(Instruction31c instruction31c) {
        if (instruction31c instanceof ImmutableInstruction31c) {
            return (ImmutableInstruction31c)instruction31c;
        }
        return new ImmutableInstruction31c(instruction31c.getOpcode(), instruction31c.getRegisterA(), instruction31c.getReference());
    }

    @Override
    public int getRegisterA() {
        return this.registerA;
    }

    @Override
    public ImmutableReference getReference() {
        return this.reference;
    }

    @Override
    public int getReferenceType() {
        return this.opcode.referenceType;
    }

    @Override
    public Format getFormat() {
        return FORMAT;
    }
}

