/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import android.app.Instrumentation;
import android.content.Context;
import android.content.pm.ApplicationInfo;
import android.support.annotation.NonNull;
import com.github.tmurakami.dexopener.ClassNameFilter;
import com.github.tmurakami.dexopener.ClassNameFilterWrapper;
import com.github.tmurakami.dexopener.DexClassFileFactory;
import com.github.tmurakami.dexopener.DexFileLoader;
import com.github.tmurakami.dexopener.DexOpenerImpl;

public abstract class DexOpener {
    DexOpener() {
    }

    public static void install(@NonNull Instrumentation instrumentation) {
        Context context = instrumentation.getTargetContext();
        if (context == null) {
            throw new IllegalArgumentException("'instrumentation' has not been initialized yet");
        }
        DexOpener.builder(context).build().installTo(context.getClassLoader());
    }

    public abstract void installTo(@NonNull ClassLoader var1);

    @NonNull
    public static Builder builder(@NonNull Context context) {
        return new Builder(context.getApplicationInfo(), new DexFileLoader(), new DexClassFileFactory(), DexOpener.openClassesBelongingTo(context.getPackageName()));
    }

    private static ClassNameFilter openClassesBelongingTo(String packageName) {
        final String packagePrefix = packageName + '.';
        return new ClassNameFilter(){

            @Override
            public boolean accept(@NonNull String className) {
                return className.startsWith(packagePrefix);
            }
        };
    }

    public static final class Builder {
        private final ApplicationInfo applicationInfo;
        private final DexFileLoader dexFileLoader;
        private final DexClassFileFactory dexClassFileFactory;
        private ClassNameFilter classNameFilter;

        private Builder(ApplicationInfo applicationInfo, DexFileLoader dexFileLoader, DexClassFileFactory dexClassFileFactory, ClassNameFilter classNameFilter) {
            this.applicationInfo = applicationInfo;
            this.dexFileLoader = dexFileLoader;
            this.dexClassFileFactory = dexClassFileFactory;
            this.classNameFilter = classNameFilter;
        }

        @NonNull
        public Builder openIf(@NonNull ClassNameFilter filter) {
            return this.classNameFilter(filter);
        }

        @NonNull
        public Builder classNameFilter(@NonNull ClassNameFilter filter) {
            this.classNameFilter = filter;
            return this;
        }

        @NonNull
        public DexOpener build() {
            return new DexOpenerImpl(this.applicationInfo, new ClassNameFilterWrapper(this.classNameFilter), this.dexFileLoader, this.dexClassFileFactory);
        }
    }
}

