/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import com.github.tmurakami.dexopener.ClassNameFilter;
import com.github.tmurakami.dexopener.DexClassFileFactory;
import com.github.tmurakami.dexopener.DexClassSource;
import com.github.tmurakami.dexopener.DexFileLoader;
import com.github.tmurakami.dexopener.TypeUtils;
import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.ClassFile;
import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.ClassSource;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcodes;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.ClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.ImmutableClassDef;
import dalvik.system.DexFile;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

final class DexClassSourceFactory {
    private static final int MAX_CLASSES_PER_DEX_FILE = 150;
    private static final Opcodes OPCODES = Opcodes.getDefault();
    private static final ClassSource NULL_SOURCE = new ClassSource(){

        public ClassFile getClassFile(String s) throws IOException {
            return null;
        }
    };
    private final ClassNameFilter classNameFilter;
    private final File cacheDir;
    private final DexFileLoader dexFileLoader;
    private final DexClassFileFactory dexClassFileFactory;

    DexClassSourceFactory(ClassNameFilter classNameFilter, File cacheDir, DexFileLoader dexFileLoader, DexClassFileFactory dexClassFileFactory) {
        this.classNameFilter = classNameFilter;
        this.cacheDir = cacheDir;
        this.dexFileLoader = dexFileLoader;
        this.dexClassFileFactory = dexClassFileFactory;
    }

    ClassSource newClassSource(byte[] bytecode) {
        DexBackedDexFile file = new DexBackedDexFile(OPCODES, bytecode);
        Set<Set<ClassDef>> classesSet = this.getClassesSetToBeOpened(file);
        if (classesSet.isEmpty()) {
            return NULL_SOURCE;
        }
        return new DexClassSource(OPCODES, new HashMap<String, DexFile>(), classesSet, this.cacheDir, this.dexFileLoader, this.dexClassFileFactory);
    }

    private Set<Set<ClassDef>> getClassesSetToBeOpened(DexBackedDexFile file) {
        HashSet<Set<ClassDef>> classesSet = new HashSet<Set<ClassDef>>();
        HashSet<ImmutableClassDef> classes = new HashSet<ImmutableClassDef>();
        for (ClassDef def : file.getClasses()) {
            if (!this.classNameFilter.accept(TypeUtils.getClassName(def.getType()))) continue;
            classes.add(ImmutableClassDef.of((ClassDef)def));
            if (classes.size() != 150) continue;
            classesSet.add(Collections.unmodifiableSet(classes));
            classes = new HashSet();
        }
        if (!classes.isEmpty()) {
            classesSet.add(Collections.unmodifiableSet(classes));
        }
        return classesSet;
    }
}

