/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.value;

import com.github.tmurakami.dexopener.repackaged.com.google.common.base.Preconditions;
import com.github.tmurakami.dexopener.repackaged.com.google.common.collect.ImmutableList;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.AnnotationEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.ArrayEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.BooleanEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.ByteEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.CharEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.DoubleEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.EncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.EnumEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.FieldEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.FloatEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.IntEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.LongEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.MethodEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.ShortEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.StringEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.TypeEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.value.ImmutableAnnotationEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.value.ImmutableArrayEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.value.ImmutableBooleanEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.value.ImmutableByteEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.value.ImmutableCharEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.value.ImmutableDoubleEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.value.ImmutableEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.value.ImmutableEnumEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.value.ImmutableFieldEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.value.ImmutableFloatEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.value.ImmutableIntEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.value.ImmutableLongEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.value.ImmutableMethodEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.value.ImmutableNullEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.value.ImmutableShortEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.value.ImmutableStringEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.value.ImmutableTypeEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.ExceptionWithContext;
import com.github.tmurakami.dexopener.repackaged.org.jf.util.ImmutableConverter;

public class ImmutableEncodedValueFactory {
    private static final ImmutableConverter<ImmutableEncodedValue, EncodedValue> CONVERTER = new ImmutableConverter<ImmutableEncodedValue, EncodedValue>(){

        @Override
        protected boolean isImmutable(EncodedValue encodedValue) {
            return encodedValue instanceof ImmutableEncodedValue;
        }

        @Override
        protected ImmutableEncodedValue makeImmutable(EncodedValue encodedValue) {
            return ImmutableEncodedValueFactory.of(encodedValue);
        }
    };

    public static ImmutableEncodedValue of(EncodedValue encodedValue) {
        switch (encodedValue.getValueType()) {
            case 0: {
                return ImmutableByteEncodedValue.of((ByteEncodedValue)encodedValue);
            }
            case 2: {
                return ImmutableShortEncodedValue.of((ShortEncodedValue)encodedValue);
            }
            case 3: {
                return ImmutableCharEncodedValue.of((CharEncodedValue)encodedValue);
            }
            case 4: {
                return ImmutableIntEncodedValue.of((IntEncodedValue)encodedValue);
            }
            case 6: {
                return ImmutableLongEncodedValue.of((LongEncodedValue)encodedValue);
            }
            case 16: {
                return ImmutableFloatEncodedValue.of((FloatEncodedValue)encodedValue);
            }
            case 17: {
                return ImmutableDoubleEncodedValue.of((DoubleEncodedValue)encodedValue);
            }
            case 23: {
                return ImmutableStringEncodedValue.of((StringEncodedValue)encodedValue);
            }
            case 24: {
                return ImmutableTypeEncodedValue.of((TypeEncodedValue)encodedValue);
            }
            case 25: {
                return ImmutableFieldEncodedValue.of((FieldEncodedValue)encodedValue);
            }
            case 26: {
                return ImmutableMethodEncodedValue.of((MethodEncodedValue)encodedValue);
            }
            case 27: {
                return ImmutableEnumEncodedValue.of((EnumEncodedValue)encodedValue);
            }
            case 28: {
                return ImmutableArrayEncodedValue.of((ArrayEncodedValue)encodedValue);
            }
            case 29: {
                return ImmutableAnnotationEncodedValue.of((AnnotationEncodedValue)encodedValue);
            }
            case 30: {
                return ImmutableNullEncodedValue.INSTANCE;
            }
            case 31: {
                return ImmutableBooleanEncodedValue.of((BooleanEncodedValue)encodedValue);
            }
        }
        Preconditions.checkArgument(false);
        return null;
    }

    public static EncodedValue defaultValueForType(String string) {
        switch (string.charAt(0)) {
            case 'Z': {
                return ImmutableBooleanEncodedValue.FALSE_VALUE;
            }
            case 'B': {
                return new ImmutableByteEncodedValue(0);
            }
            case 'S': {
                return new ImmutableShortEncodedValue(0);
            }
            case 'C': {
                return new ImmutableCharEncodedValue('\u0000');
            }
            case 'I': {
                return new ImmutableIntEncodedValue(0);
            }
            case 'J': {
                return new ImmutableLongEncodedValue(0L);
            }
            case 'F': {
                return new ImmutableFloatEncodedValue(0.0f);
            }
            case 'D': {
                return new ImmutableDoubleEncodedValue(0.0);
            }
            case 'L': 
            case '[': {
                return ImmutableNullEncodedValue.INSTANCE;
            }
        }
        throw new ExceptionWithContext("Unrecognized type: %s", string);
    }

    public static ImmutableEncodedValue ofNullable(EncodedValue encodedValue) {
        if (encodedValue == null) {
            return null;
        }
        return ImmutableEncodedValueFactory.of(encodedValue);
    }

    public static ImmutableList<ImmutableEncodedValue> immutableListOf(Iterable<? extends EncodedValue> iterable) {
        return CONVERTER.toList(iterable);
    }
}

