/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.instruction;

import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Format;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcode;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.instruction.formats.Instruction22c;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.reference.Reference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.instruction.ImmutableInstruction;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.reference.ImmutableReference;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.reference.ImmutableReferenceFactory;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.util.Preconditions;

public class ImmutableInstruction22c
extends ImmutableInstruction
implements Instruction22c {
    public static final Format FORMAT = Format.Format22c;
    protected final int registerA;
    protected final int registerB;
    protected final ImmutableReference reference;

    public ImmutableInstruction22c(Opcode opcode, int n, int n2, Reference reference) {
        super(opcode);
        this.registerA = Preconditions.checkNibbleRegister(n);
        this.registerB = Preconditions.checkNibbleRegister(n2);
        this.reference = ImmutableReferenceFactory.of(opcode.referenceType, reference);
    }

    public static ImmutableInstruction22c of(Instruction22c instruction22c) {
        if (instruction22c instanceof ImmutableInstruction22c) {
            return (ImmutableInstruction22c)instruction22c;
        }
        return new ImmutableInstruction22c(instruction22c.getOpcode(), instruction22c.getRegisterA(), instruction22c.getRegisterB(), instruction22c.getReference());
    }

    @Override
    public int getRegisterA() {
        return this.registerA;
    }

    @Override
    public int getRegisterB() {
        return this.registerB;
    }

    @Override
    public ImmutableReference getReference() {
        return this.reference;
    }

    @Override
    public int getReferenceType() {
        return this.opcode.referenceType;
    }

    @Override
    public Format getFormat() {
        return FORMAT;
    }
}

