/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import com.github.tmurakami.dexopener.DexFileLoader;
import com.github.tmurakami.dexopener.DexFiles;
import com.github.tmurakami.dexopener.FileUtils;
import com.github.tmurakami.dexopener.Loggers;
import com.github.tmurakami.dexopener.TypeUtils;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcodes;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Annotation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.AnnotationElement;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.ClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.Method;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.EncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.value.IntEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.ImmutableAnnotation;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.ImmutableAnnotationElement;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.ImmutableClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.ImmutableMethod;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.value.ImmutableIntEncodedValue;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.io.DexDataStore;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.io.FileDataStore;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.writer.pool.DexPool;
import dalvik.system.DexFile;
import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

final class DexFilesImpl
implements DexFiles {
    private final Opcodes opcodes;
    private final Map<String, DexFile> dexFileMap;
    private final Set<Set<ClassDef>> classesSet;
    private final File cacheDir;
    private final DexFileLoader dexFileLoader;

    DexFilesImpl(Opcodes opcodes, Map<String, DexFile> dexFileMap, Set<Set<ClassDef>> classesSet, File cacheDir, DexFileLoader dexFileLoader) {
        this.opcodes = opcodes;
        this.dexFileMap = dexFileMap;
        this.classesSet = classesSet;
        this.cacheDir = cacheDir;
        this.dexFileLoader = dexFileLoader;
    }

    @Override
    public DexFile get(String className) throws IOException {
        DexFile dexFile = this.getFromCache(className);
        if (dexFile != null) {
            return dexFile;
        }
        Set<ClassDef> classes = this.getClassesToBeOpened(className);
        return classes.isEmpty() ? null : this.putToCache(this.generateDex(this.openClasses(classes)));
    }

    private DexFile getFromCache(String className) {
        DexFile dexFile = this.dexFileMap.get(className);
        if (dexFile == null) {
            return null;
        }
        Logger logger = Loggers.get();
        if (logger.isLoggable(Level.FINEST)) {
            logger.finest("The DEX file for " + className + " was found in the cache");
        }
        return dexFile;
    }

    private Set<ClassDef> getClassesToBeOpened(String className) {
        Iterator<Set<ClassDef>> it = this.classesSet.iterator();
        while (it.hasNext()) {
            Set<ClassDef> classes = it.next();
            for (ClassDef def : classes) {
                if (!def.getType().equals(TypeUtils.getInternalName(className))) continue;
                it.remove();
                return classes;
            }
        }
        return Collections.emptySet();
    }

    private DexPool openClasses(Set<ClassDef> classes) {
        DexPool pool = new DexPool(this.opcodes);
        for (ClassDef def : classes) {
            pool.internClass(DexFilesImpl.openClass(def));
            Logger logger = Loggers.get();
            if (!logger.isLoggable(Level.FINEST)) continue;
            logger.finest("Class to be opened: " + TypeUtils.getClassName(def.getType()));
        }
        return pool;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private DexFile generateDex(DexPool pool) throws IOException {
        DexFile dexFile;
        if (!this.cacheDir.isDirectory() && !this.cacheDir.mkdirs()) {
            throw new IOException("Cannot create " + this.cacheDir);
        }
        File dex = File.createTempFile("classes", ".dex", this.cacheDir);
        try {
            pool.writeTo((DexDataStore)new FileDataStore(dex));
            String sourcePathName = dex.getCanonicalPath();
            String outputPathName = sourcePathName + ".opt";
            DexFile dexFile2 = this.dexFileLoader.loadDex(sourcePathName, outputPathName, 0);
            Logger logger = Loggers.get();
            if (logger.isLoggable(Level.FINEST)) {
                logger.finest("An optimized DEX file generated: " + outputPathName);
            }
            dexFile = dexFile2;
        }
        catch (Throwable throwable) {
            FileUtils.delete(dex);
            throw throwable;
        }
        FileUtils.delete(dex);
        return dexFile;
    }

    private DexFile putToCache(DexFile dexFile) {
        Enumeration e = dexFile.entries();
        while (e.hasMoreElements()) {
            this.dexFileMap.put((String)e.nextElement(), dexFile);
        }
        return dexFile;
    }

    private static ClassDef openClass(ClassDef def) {
        return new ImmutableClassDef(def.getType(), DexFilesImpl.removeFinalModifier(def.getAccessFlags()), def.getSuperclass(), (Collection)def.getInterfaces(), def.getSourceFile(), DexFilesImpl.openInnerClassAnnotation(def.getAnnotations()), def.getFields(), DexFilesImpl.openMethods(def.getMethods()));
    }

    private static int removeFinalModifier(int accessFlags) {
        return accessFlags & 0xFFFFFFEF;
    }

    private static Set<Annotation> openInnerClassAnnotation(Set<? extends Annotation> annotations) {
        HashSet<Annotation> openedAnnotations = new HashSet<Annotation>();
        for (Annotation annotation : annotations) {
            String type = annotation.getType();
            if (type.equals("Ldalvik/annotation/InnerClass;")) {
                HashSet<Object> elementSet = new HashSet<Object>();
                for (AnnotationElement e : annotation.getElements()) {
                    String name = e.getName();
                    if (name.equals("accessFlags")) {
                        IntEncodedValue value = (IntEncodedValue)e.getValue();
                        int accessFlags = DexFilesImpl.removeFinalModifier(value.getValue());
                        ImmutableIntEncodedValue newValue = new ImmutableIntEncodedValue(accessFlags);
                        elementSet.add(new ImmutableAnnotationElement(name, (EncodedValue)newValue));
                        continue;
                    }
                    elementSet.add(e);
                }
                openedAnnotations.add((Annotation)new ImmutableAnnotation(annotation.getVisibility(), type, elementSet));
                continue;
            }
            openedAnnotations.add(annotation);
        }
        return openedAnnotations;
    }

    private static Set<Method> openMethods(Iterable<? extends Method> methods) {
        HashSet<Method> openedMethods = new HashSet<Method>();
        for (Method method : methods) {
            openedMethods.add((Method)new ImmutableMethod(method.getDefiningClass(), method.getName(), (Iterable)method.getParameters(), method.getReturnType(), DexFilesImpl.removeFinalModifier(method.getAccessFlags()), method.getAnnotations(), method.getImplementation()));
        }
        return openedMethods;
    }
}

