/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener;

import com.github.tmurakami.dexopener.ClassNameFilter;
import com.github.tmurakami.dexopener.DexFileLoader;
import com.github.tmurakami.dexopener.DexFiles;
import com.github.tmurakami.dexopener.DexFilesImpl;
import com.github.tmurakami.dexopener.TypeUtils;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.Opcodes;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.dexbacked.DexBackedDexFile;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.iface.ClassDef;
import com.github.tmurakami.dexopener.repackaged.org.jf.dexlib2.immutable.ImmutableClassDef;
import dalvik.system.DexFile;
import java.io.File;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;

final class DexFilesFactory {
    private static final int MAX_CLASSES_PER_DEX_FILE = 150;
    private static final Opcodes OPCODES = Opcodes.getDefault();
    private static final DexFiles NULL_FILES = new DexFiles(){

        @Override
        public DexFile get(String className) throws IOException {
            return null;
        }
    };
    private final ClassNameFilter classNameFilter;
    private final File cacheDir;
    private final DexFileLoader dexFileLoader;

    DexFilesFactory(ClassNameFilter classNameFilter, File cacheDir, DexFileLoader dexFileLoader) {
        this.classNameFilter = classNameFilter;
        this.cacheDir = cacheDir;
        this.dexFileLoader = dexFileLoader;
    }

    DexFiles newDexFiles(byte[] bytecode) {
        DexBackedDexFile file = new DexBackedDexFile(OPCODES, bytecode);
        Set<Set<ClassDef>> classesSet = this.getClassesSetToBeOpened(file);
        return classesSet.isEmpty() ? NULL_FILES : new DexFilesImpl(OPCODES, new HashMap<String, DexFile>(), classesSet, this.cacheDir, this.dexFileLoader);
    }

    private Set<Set<ClassDef>> getClassesSetToBeOpened(DexBackedDexFile file) {
        HashSet<Set<ClassDef>> classesSet = new HashSet<Set<ClassDef>>();
        HashSet<ImmutableClassDef> classes = new HashSet<ImmutableClassDef>();
        for (ClassDef def : file.getClasses()) {
            if (!this.classNameFilter.accept(TypeUtils.getClassName(def.getType()))) continue;
            classes.add(ImmutableClassDef.of((ClassDef)def));
            if (classes.size() != 150) continue;
            classesSet.add(Collections.unmodifiableSet(classes));
            classes = new HashSet();
        }
        if (!classes.isEmpty()) {
            classesSet.add(Collections.unmodifiableSet(classes));
        }
        return classesSet;
    }
}

