/*
 * Decompiled with CFR 0.152.
 */
package com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector;

import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.ClassInjector;
import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.ClassLoaderFactory;
import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.ClassLoaderHelper;
import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.ClassSource;
import com.github.tmurakami.dexopener.repackaged.com.github.tmurakami.classinjector.StealthClassLoader;

final class ClassInjectorImpl
extends ClassInjector {
    private final ClassSource source;
    private final ClassLoaderFactory classLoaderFactory;
    private final ClassLoaderHelper classLoaderHelper;

    ClassInjectorImpl(ClassSource classSource, ClassLoaderFactory classLoaderFactory, ClassLoaderHelper classLoaderHelper) {
        this.source = classSource;
        this.classLoaderFactory = classLoaderFactory;
        this.classLoaderHelper = classLoaderHelper;
    }

    @Override
    public void into(ClassLoader classLoader) {
        ClassLoaderHelper classLoaderHelper = this.classLoaderHelper;
        ClassLoader classLoader2 = classLoaderHelper.getParent(classLoader);
        if (classLoader2 == null) {
            throw new IllegalArgumentException("The parent of 'target' is null");
        }
        if (classLoader instanceof StealthClassLoader || classLoader2 instanceof StealthClassLoader) {
            throw new IllegalArgumentException("'target' has already been injected");
        }
        classLoaderHelper.setParent(classLoader, this.classLoaderFactory.newClassLoader(classLoader2, this.source, classLoader));
    }
}

