/*
 * Decompiled with CFR 0.152.
 */
package com.github.tlrx.elasticsearch.test.support.junit.rules;

import com.github.tlrx.elasticsearch.test.support.junit.handlers.ElasticsearchAnnotationHandler;
import com.github.tlrx.elasticsearch.test.support.junit.handlers.MethodLevelElasticsearchAnnotationHandler;
import com.github.tlrx.elasticsearch.test.support.junit.rules.AbstractElasticsearchRule;
import java.lang.annotation.Annotation;
import java.util.Collection;
import java.util.Map;
import java.util.logging.Logger;

public class ElasticsearchTestRule
extends AbstractElasticsearchRule {
    private static final Logger LOGGER = Logger.getLogger(ElasticsearchTestRule.class.getName());
    private final Object instance;

    public ElasticsearchTestRule(Map<String, Object> context, Object testInstance) {
        super(context);
        this.instance = testInstance;
    }

    @Override
    protected void before(Collection<Annotation> annotations) throws Exception {
        this.executeBeforeOrAfterMethodHandlers(true, annotations);
    }

    @Override
    protected void after(Collection<Annotation> annotations) throws Exception {
        this.executeBeforeOrAfterMethodHandlers(false, annotations);
    }

    private void executeBeforeOrAfterMethodHandlers(boolean isBefore, Collection<Annotation> annotations) throws Exception {
        if (annotations != null && !annotations.isEmpty()) {
            for (ElasticsearchAnnotationHandler handler : this.handlers) {
                if (!(handler instanceof MethodLevelElasticsearchAnnotationHandler)) continue;
                for (Annotation annotation : annotations) {
                    if (!handler.support(annotation)) continue;
                    if (isBefore) {
                        ((MethodLevelElasticsearchAnnotationHandler)handler).handleBefore(annotation, this.instance, this.context);
                        continue;
                    }
                    try {
                        ((MethodLevelElasticsearchAnnotationHandler)handler).handleAfter(annotation, this.instance, this.context);
                    }
                    catch (Exception e) {
                        LOGGER.severe(e.getMessage());
                    }
                }
            }
        }
    }
}

