/*
 * Decompiled with CFR 0.152.
 */
package com.github.tlrx.elasticsearch.test.support.junit.handlers.annotations;

import com.github.tlrx.elasticsearch.test.annotations.ElasticsearchTransportClient;
import com.github.tlrx.elasticsearch.test.support.junit.handlers.ClassLevelElasticsearchAnnotationHandler;
import com.github.tlrx.elasticsearch.test.support.junit.handlers.FieldLevelElasticsearchAnnotationHandler;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.util.Map;
import java.util.logging.Logger;
import org.elasticsearch.client.transport.TransportClient;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;
import org.elasticsearch.common.transport.InetSocketTransportAddress;
import org.elasticsearch.common.transport.TransportAddress;

public class ElasticsearchTransportClientAnnotationHandler
implements ClassLevelElasticsearchAnnotationHandler,
FieldLevelElasticsearchAnnotationHandler {
    private static final Logger LOGGER = Logger.getLogger(ElasticsearchTransportClientAnnotationHandler.class.getName());

    @Override
    public boolean support(Annotation annotation) {
        return annotation instanceof ElasticsearchTransportClient;
    }

    @Override
    public void handleField(Annotation annotation, Object instance, Map<String, Object> context, Field field) {
        ElasticsearchTransportClient elasticsearchTransportClient = (ElasticsearchTransportClient)annotation;
        Settings settings = ImmutableSettings.settingsBuilder().put("cluster.name", String.valueOf(elasticsearchTransportClient.clusterName())).build();
        TransportClient client = new TransportClient(settings);
        int n = 0;
        for (String host : elasticsearchTransportClient.hostnames()) {
            client.addTransportAddress((TransportAddress)new InetSocketTransportAddress(host, elasticsearchTransportClient.ports()[n++]));
        }
        if (client != null) {
            try {
                field.setAccessible(true);
                field.set(instance, client);
                context.put(client.toString(), client);
            }
            catch (Exception e) {
                LOGGER.severe("Unable to set transport client for field " + field.getName() + ":" + e.getMessage());
            }
        }
    }

    @Override
    public void beforeClass(Object testClass, Map<String, Object> context) throws Exception {
    }

    @Override
    public void handleBeforeClass(Annotation annotation, Object testClass, Map<String, Object> context) throws Exception {
    }

    @Override
    public void handleAfterClass(Annotation annotation, Object testClass, Map<String, Object> context) throws Exception {
    }

    @Override
    public void afterClass(Object testClass, Map<String, Object> context) throws Exception {
        for (Object obj : context.values()) {
            if (!(obj instanceof TransportClient)) continue;
            TransportClient client = (TransportClient)obj;
            client.close();
        }
    }
}

