/*
 * Decompiled with CFR 0.152.
 */
package com.github.tlrx.elasticsearch.test.support.junit.handlers.annotations;

import com.github.tlrx.elasticsearch.test.annotations.ElasticsearchBulkRequest;
import com.github.tlrx.elasticsearch.test.support.junit.handlers.MethodLevelElasticsearchAnnotationHandler;
import com.github.tlrx.elasticsearch.test.support.junit.handlers.annotations.AbstractAnnotationHandler;
import java.io.ByteArrayOutputStream;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Map;
import java.util.logging.Logger;
import org.elasticsearch.action.bulk.BulkResponse;
import org.elasticsearch.client.Client;

public class ElasticsearchBulkRequestAnnotationHandler
extends AbstractAnnotationHandler
implements MethodLevelElasticsearchAnnotationHandler {
    private static final Logger LOGGER = Logger.getLogger(ElasticsearchBulkRequestAnnotationHandler.class.getName());

    @Override
    public boolean support(Annotation annotation) {
        return annotation instanceof ElasticsearchBulkRequest;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void handleBefore(Annotation annotation, Object instance, Map<String, Object> context) throws Exception {
        ElasticsearchBulkRequest elasticsearchBulkRequest = (ElasticsearchBulkRequest)annotation;
        InputStream input = null;
        ByteArrayOutputStream output = null;
        try {
            Client client = this.client(context, elasticsearchBulkRequest.nodeName());
            input = this.getClass().getResourceAsStream(elasticsearchBulkRequest.dataFile());
            if (input == null) {
                input = Thread.currentThread().getContextClassLoader().getResourceAsStream(elasticsearchBulkRequest.dataFile());
            }
            if (input == null) {
                throw new IllegalArgumentException("Bulk file " + elasticsearchBulkRequest.dataFile() + " not found!");
            }
            output = new ByteArrayOutputStream();
            byte[] buffer = new byte[524288];
            while (input.read(buffer) > 0) {
                output.write(buffer);
            }
            buffer = output.toByteArray();
            BulkResponse response = (BulkResponse)client.prepareBulk().add(buffer, 0, buffer.length, true, elasticsearchBulkRequest.defaultIndexName(), elasticsearchBulkRequest.defaultTypeName()).setRefresh(true).execute().actionGet();
            LOGGER.info(String.format("Bulk request for data file '%s' executed in %d ms with %sfailures", elasticsearchBulkRequest.dataFile(), response.getTookInMillis(), response.hasFailures() ? "" : "no "));
        }
        finally {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (Exception e) {}
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (Exception e) {}
        }
    }

    @Override
    public void handleAfter(Annotation annotation, Object instance, Map<String, Object> context) throws Exception {
    }
}

