/*
 * Decompiled with CFR 0.152.
 */
package com.github.tlrx.elasticsearch.test.request;

import com.github.tlrx.elasticsearch.test.request.Request;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.admin.indices.exists.indices.IndicesExistsResponse;
import org.elasticsearch.action.get.GetResponse;
import org.elasticsearch.client.Client;

public class Exists
implements Request<Boolean> {
    private String index;
    private String type;
    private String id;

    public Exists(String index) {
        this.index = index;
    }

    public Exists(String index, String type, String id) {
        this(index);
        this.type = type;
        this.id = id;
    }

    @Override
    public Boolean execute(Client client) throws ElasticsearchException {
        if (this.index != null && this.type != null && this.id != null) {
            GetResponse response = (GetResponse)client.prepareGet(this.index, this.type, this.id).setRefresh(true).execute().actionGet();
            return response.isExists();
        }
        IndicesExistsResponse response = (IndicesExistsResponse)client.admin().indices().prepareExists(new String[]{this.index}).execute().actionGet();
        return response.isExists();
    }

    public String toString() {
        return "exists [index='" + this.index + '\'' + ", type='" + this.type + '\'' + ", id='" + this.id + '\'' + ']';
    }
}

