/*
 * Decompiled with CFR 0.152.
 */
package com.github.tlrx.elasticsearch.test.request;

import com.github.tlrx.elasticsearch.test.EsSetupRuntimeException;
import com.github.tlrx.elasticsearch.test.provider.JSONProvider;
import com.github.tlrx.elasticsearch.test.request.Request;
import java.util.Map;
import org.elasticsearch.ElasticsearchException;
import org.elasticsearch.action.ActionRequest;
import org.elasticsearch.action.admin.indices.IndicesAction;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateAction;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateRequest;
import org.elasticsearch.action.admin.indices.template.put.PutIndexTemplateResponse;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.settings.ImmutableSettings;
import org.elasticsearch.common.settings.Settings;

public class CreateTemplate
implements Request<Void> {
    private final PutIndexTemplateRequest request;
    private String name;

    public CreateTemplate(String name) {
        this.name = name;
        this.request = new PutIndexTemplateRequest(name);
    }

    public CreateTemplate withTemplate(String template) {
        this.request.template(template);
        return this;
    }

    public CreateTemplate withSettings(Settings settings) {
        this.request.settings(settings);
        return this;
    }

    public CreateTemplate withSettings(String source) {
        Settings settings = ImmutableSettings.settingsBuilder().loadFromSource(source).build();
        this.withSettings(settings);
        return this;
    }

    public CreateTemplate withSettings(JSONProvider jsonProvider) {
        this.withSettings(jsonProvider.toJson());
        return this;
    }

    public CreateTemplate withMapping(String type, Map mapping) {
        this.request.mapping(type, mapping);
        return this;
    }

    public CreateTemplate withMapping(String type, String source) {
        this.request.mapping(type, source);
        return this;
    }

    public CreateTemplate withMapping(String type, JSONProvider jsonProvider) {
        this.withMapping(type, jsonProvider.toJson());
        return this;
    }

    public CreateTemplate withSource(String source) {
        this.request.source(source);
        return this;
    }

    public CreateTemplate withSource(JSONProvider jsonProvider) {
        this.request.source(jsonProvider.toJson());
        return this;
    }

    @Override
    public Void execute(Client client) throws ElasticsearchException {
        try {
            PutIndexTemplateResponse response = (PutIndexTemplateResponse)client.admin().indices().execute((IndicesAction)PutIndexTemplateAction.INSTANCE, (ActionRequest)this.request).get();
            if (!response.isAcknowledged()) {
                throw new EsSetupRuntimeException("Exception when putting index template");
            }
        }
        catch (Exception e) {
            throw new EsSetupRuntimeException(e);
        }
        return null;
    }

    public String toString() {
        return "create template [name='" + this.name + '\'' + ']';
    }
}

