/*
 * Decompiled with CFR 0.152.
 */
package com.github.tlrx.elasticsearch.test.provider;

import com.github.tlrx.elasticsearch.test.provider.ClientProvider;
import org.elasticsearch.client.Client;
import org.elasticsearch.common.Preconditions;
import org.elasticsearch.common.unit.TimeValue;

public class DefaultClientProvider
implements ClientProvider {
    private final Client client;
    private final boolean closeOnTerminate;

    public DefaultClientProvider(Client client, boolean closeClientOnTerminate) {
        Preconditions.checkNotNull((Object)client, (Object)"No Client specified");
        this.closeOnTerminate = closeClientOnTerminate;
        this.client = client;
    }

    @Override
    public void open() {
        this.client().admin().cluster().prepareHealth(new String[0]).setWaitForYellowStatus().setTimeout(TimeValue.timeValueMinutes((long)1L)).execute().actionGet();
    }

    @Override
    public Client client() {
        return this.client;
    }

    @Override
    public void close() {
        if (this.closeOnTerminate) {
            this.client().close();
        }
    }
}

