/*
 * Decompiled with CFR 0.152.
 */
package com.github.tlrx.elasticsearch.test.provider;

import com.github.tlrx.elasticsearch.test.EsSetupRuntimeException;
import com.github.tlrx.elasticsearch.test.provider.JSONProvider;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import org.elasticsearch.common.Preconditions;
import org.elasticsearch.common.io.Streams;

public class ClassPathJSONProvider
implements JSONProvider {
    private Class klass;
    private ClassLoader classLoader;
    private String path;

    public ClassPathJSONProvider(ClassLoader classLoader, String path) {
        Preconditions.checkNotNull((Object)classLoader, (Object)"No ClassLoader specified");
        this.classLoader = classLoader;
        this.path = path;
    }

    public ClassPathJSONProvider(Class klass, String path) {
        Preconditions.checkNotNull((Object)klass, (Object)"No Class specified");
        this.klass = klass;
        this.path = path;
    }

    @Override
    public String toJson() {
        return this.toString();
    }

    public String toString() {
        try {
            if (this.klass != null) {
                InputStream inputStream = this.klass.getResourceAsStream(this.path);
                if (inputStream == null) {
                    throw new FileNotFoundException("Resource [" + this.path + "] not found in classpath with class  [" + this.klass.getName() + "]");
                }
                return Streams.copyToString((Reader)new InputStreamReader(inputStream, "UTF-8"));
            }
            return Streams.copyToStringFromClasspath((ClassLoader)this.classLoader, (String)this.path);
        }
        catch (IOException e) {
            throw new EsSetupRuntimeException(e);
        }
    }
}

