/*
 * Decompiled with CFR 0.152.
 */
package me.tittojose.www.timerangepicker_library;

import android.app.Activity;
import android.os.Bundle;
import android.support.v4.app.DialogFragment;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.Button;
import android.widget.TabHost;
import android.widget.TimePicker;
import me.tittojose.www.timerangepicker_library.R;

public class TimeRangePickerDialog
extends DialogFragment
implements View.OnClickListener {
    TabHost tabs;
    Button setTimeRange;
    TimePicker startTimePicker;
    TimePicker endTimePicker;
    IOnTimeRangeSelected onTimeRangeSelectedListener;

    public void onAttach(Activity activity) {
        super.onAttach(activity);
        try {
            this.onTimeRangeSelectedListener = (IOnTimeRangeSelected)activity;
        }
        catch (ClassCastException e) {
            throw new ClassCastException(activity.toString() + " must implement IOnTimeRangeSelected");
        }
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        View root = inflater.inflate(R.layout.timerange_picker_dialog, container, false);
        this.getDialog().getWindow().requestFeature(1);
        this.tabs = (TabHost)root.findViewById(R.id.tabHost);
        this.setTimeRange = (Button)root.findViewById(R.id.bSetTimeRange);
        this.startTimePicker = (TimePicker)root.findViewById(R.id.startTimePicker);
        this.endTimePicker = (TimePicker)root.findViewById(R.id.endTimePicker);
        this.setTimeRange.setOnClickListener((View.OnClickListener)this);
        this.tabs.findViewById(R.id.tabHost);
        this.tabs.setup();
        TabHost.TabSpec tabpage1 = this.tabs.newTabSpec("one");
        tabpage1.setContent(R.id.startTimeGroup);
        tabpage1.setIndicator((CharSequence)"Start Time");
        TabHost.TabSpec tabpage2 = this.tabs.newTabSpec("two");
        tabpage2.setContent(R.id.endTimeGroup);
        tabpage2.setIndicator((CharSequence)"End Time");
        this.tabs.addTab(tabpage1);
        this.tabs.addTab(tabpage2);
        return root;
    }

    public void onStart() {
        super.onStart();
        if (this.getDialog() == null) {
            return;
        }
        this.getDialog().getWindow().setLayout(-1, -2);
    }

    public void onClick(View v) {
        if (v.getId() == R.id.bSetTimeRange) {
            this.dismiss();
            int startHour = this.startTimePicker.getCurrentHour();
            int startMin = this.startTimePicker.getCurrentMinute();
            int endHour = this.endTimePicker.getCurrentHour();
            int endMin = this.endTimePicker.getCurrentMinute();
            this.onTimeRangeSelectedListener.onTimeRangeSelected(startHour, startMin, endHour, endMin);
        }
    }

    public static interface IOnTimeRangeSelected {
        public void onTimeRangeSelected(int var1, int var2, int var3, int var4);
    }
}

