/*
 * Decompiled with CFR 0.152.
 */
package com.github.timurstrekalov.saga.core.sourcepreloader;

import com.github.timurstrekalov.saga.core.OutputStrategy;
import com.github.timurstrekalov.saga.core.cfg.Config;
import com.github.timurstrekalov.saga.core.instrumentation.HtmlUnitBasedScriptInstrumenter;
import com.github.timurstrekalov.saga.core.model.ScriptData;
import com.github.timurstrekalov.saga.core.model.TestRunCoverageStatistics;
import com.github.timurstrekalov.saga.core.sourcepreloader.SourcePreloader;
import com.github.timurstrekalov.saga.core.util.UriUtil;
import com.google.common.collect.Maps;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.List;
import org.codehaus.plexus.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileSystemSourcePreloader
implements SourcePreloader {
    private static final Logger logger = LoggerFactory.getLogger(FileSystemSourcePreloader.class);

    @Override
    public void preloadSources(Config config, TestRunCoverageStatistics totalStats) throws IOException {
        HtmlUnitBasedScriptInstrumenter instrumenter = new HtmlUnitBasedScriptInstrumenter(config);
        String sourcesToPreload = config.getSourcesToPreload();
        URI baseUri = config.getBaseUri();
        if (sourcesToPreload == null || !config.getOutputStrategy().contains(OutputStrategy.TOTAL) || !UriUtil.isFileUri(baseUri)) {
            return;
        }
        String sourcesToPreloadEncoding = config.getSourcesToPreloadEncoding();
        logger.info("Using {} to preload sources", (Object)sourcesToPreloadEncoding);
        List filesToPreload = FileUtils.getFiles((File)new File(baseUri), (String)sourcesToPreload, null);
        logger.info("Preloading {} files", (Object)filesToPreload.size());
        for (File file : filesToPreload) {
            logger.debug("Preloading {}", (Object)file);
            String source = CharStreams.toString((InputSupplier)Files.newReaderSupplier((File)file, (Charset)Charset.forName(sourcesToPreloadEncoding)));
            instrumenter.instrument(source, file.toURI().toString(), 0);
        }
        for (ScriptData data : instrumenter.getScriptDataList()) {
            HashMap coverageData = Maps.newHashMap();
            for (Integer lineNumber : data.getLineNumbersOfAllStatements()) {
                coverageData.put(String.valueOf(lineNumber), 0L);
            }
            totalStats.add(data.generateScriptCoverageStatistics(baseUri, coverageData));
        }
    }
}

