/*
 * Decompiled with CFR 0.152.
 */
package com.github.timurstrekalov.saga.core.server;

import com.github.timurstrekalov.saga.core.instrumentation.ScriptInstrumenter;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.io.InputSupplier;
import com.google.common.io.OutputSupplier;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.charset.Charset;
import java.util.Enumeration;
import java.util.Locale;
import java.util.zip.GZIPInputStream;
import java.util.zip.GZIPOutputStream;
import javax.servlet.ServletConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.eclipse.jetty.client.HttpExchange;
import org.eclipse.jetty.continuation.Continuation;
import org.eclipse.jetty.continuation.ContinuationSupport;
import org.eclipse.jetty.http.HttpHeaderValues;
import org.eclipse.jetty.http.HttpHeaders;
import org.eclipse.jetty.http.HttpSchemes;
import org.eclipse.jetty.http.HttpURI;
import org.eclipse.jetty.io.Buffer;
import org.eclipse.jetty.server.Request;
import org.eclipse.jetty.servlets.ProxyServlet;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class InstrumentingProxyServlet
extends ProxyServlet {
    public static final String INSTRUMENTER = InstrumentingProxyServlet.class.getName() + ".instrumenter";
    private static final Logger logger = LoggerFactory.getLogger(InstrumentingProxyServlet.class);
    private ScriptInstrumenter instrumenter;

    public void init(ServletConfig config) throws ServletException {
        super.init(config);
        this.instrumenter = (ScriptInstrumenter)config.getServletContext().getAttribute(INSTRUMENTER);
    }

    public void service(ServletRequest req, ServletResponse res) throws ServletException, IOException {
        long ctimeout;
        HttpServletRequest request = (HttpServletRequest)req;
        HttpServletResponse response = (HttpServletResponse)res;
        if ("CONNECT".equalsIgnoreCase(request.getMethod())) {
            this.handleConnect(request, response);
            return;
        }
        ServletInputStream in = request.getInputStream();
        Continuation continuation = ContinuationSupport.getContinuation((ServletRequest)request);
        if (!continuation.isInitial()) {
            response.sendError(504);
            return;
        }
        String uri = request.getRequestURI();
        if (request.getQueryString() != null) {
            uri = uri + "?" + request.getQueryString();
        }
        HttpURI url = this.proxyHttpURI(request, uri);
        logger.debug("proxy {}-->{}", (Object)uri, (Object)url);
        if (url == null) {
            response.sendError(403);
            return;
        }
        CustomHttpExchange exchange = new CustomHttpExchange(continuation, response, request);
        exchange.setScheme("https".equals(request.getScheme()) ? HttpSchemes.HTTPS_BUFFER : HttpSchemes.HTTP_BUFFER);
        exchange.setMethod(request.getMethod());
        exchange.setURL(url.toString());
        exchange.setVersion(request.getProtocol());
        logger.debug("{} {} {}", new Object[]{request.getMethod(), url, request.getProtocol()});
        String connectionHdr = request.getHeader("Connection");
        if (connectionHdr != null && !(connectionHdr = connectionHdr.toLowerCase(Locale.ENGLISH)).contains("keep-alive") && !connectionHdr.contains("close")) {
            connectionHdr = null;
        }
        if (this._hostHeader != null) {
            exchange.setRequestHeader("Host", this._hostHeader);
        }
        boolean xForwardedFor = false;
        boolean hasContent = false;
        long contentLength = -1L;
        Enumeration enm = request.getHeaderNames();
        while (enm.hasMoreElements()) {
            String hdr = (String)enm.nextElement();
            String lhdr = hdr.toLowerCase(Locale.ENGLISH);
            if ("transfer-encoding".equals(lhdr) && request.getHeader("transfer-encoding").contains("chunk")) {
                hasContent = true;
            }
            if (this._DontProxyHeaders.contains(lhdr) || connectionHdr != null && connectionHdr.contains(lhdr) || this._hostHeader != null && "host".equals(lhdr)) continue;
            if ("content-type".equals(lhdr)) {
                hasContent = true;
            } else if ("content-length".equals(lhdr)) {
                contentLength = request.getContentLength();
                exchange.setRequestHeader("Content-Length", Long.toString(contentLength));
                if (contentLength > 0L) {
                    hasContent = true;
                }
            } else if ("x-forwarded-for".equals(lhdr)) {
                xForwardedFor = true;
            }
            Enumeration vals = request.getHeaders(hdr);
            while (vals.hasMoreElements()) {
                String val = (String)vals.nextElement();
                if (val == null) continue;
                logger.debug("{}: {}", (Object)hdr, (Object)val);
                exchange.setRequestHeader(hdr, val);
            }
        }
        exchange.setRequestHeader("Via", "1.1 (jetty)");
        if (!xForwardedFor) {
            exchange.addRequestHeader("X-Forwarded-For", request.getRemoteAddr());
            exchange.addRequestHeader("X-Forwarded-Proto", request.getScheme());
            exchange.addRequestHeader("X-Forwarded-Host", request.getHeader("Host"));
            exchange.addRequestHeader("X-Forwarded-Server", request.getLocalName());
        }
        if (hasContent) {
            exchange.setRequestContentSource((InputStream)in);
        }
        this.customizeExchange(exchange, request);
        long l = ctimeout = this._client.getTimeout() > exchange.getTimeout() ? this._client.getTimeout() : exchange.getTimeout();
        if (ctimeout == 0L) {
            continuation.setTimeout(0L);
        } else {
            continuation.setTimeout(ctimeout + 1000L);
        }
        this.customizeContinuation(continuation);
        continuation.suspend((ServletResponse)response);
        this._client.send((HttpExchange)exchange);
    }

    private static InputStream newInputStreamForResponse(HttpServletResponse response, byte[] remoteResponseBody) throws IOException {
        ByteArrayInputStream result = new ByteArrayInputStream(remoteResponseBody);
        if (InstrumentingProxyServlet.shouldBeGzipEncoded(response)) {
            return new GZIPInputStream(result);
        }
        return result;
    }

    private static boolean shouldBeGzipEncoded(HttpServletResponse response) {
        return "gzip".equalsIgnoreCase(response.getHeader("Content-Encoding"));
    }

    private final class CustomHttpExchange
    extends HttpExchange {
        private final Continuation continuation;
        private final HttpServletResponse response;
        private final HttpServletRequest request;
        private final ByteArrayOutputStream baos = new ByteArrayOutputStream();

        public CustomHttpExchange(Continuation continuation, HttpServletResponse response, HttpServletRequest request) {
            this.continuation = continuation;
            this.response = response;
            this.request = request;
        }

        protected void onResponseComplete() throws IOException {
            byte[] in;
            final byte[] remoteResponseBody = this.baos.toByteArray();
            if (this.shouldBeInstrumented(this.request, this.response)) {
                Charset charset = this.getCharsetFrom(this.response);
                String body = CharStreams.toString((InputSupplier)CharStreams.newReaderSupplier((InputSupplier)new InputSupplier<InputStream>(){

                    public InputStream getInput() throws IOException {
                        return InstrumentingProxyServlet.newInputStreamForResponse(CustomHttpExchange.this.response, remoteResponseBody);
                    }
                }, (Charset)charset));
                String uri = this.request instanceof Request ? ((Request)this.request).getUri().toString() : this.request.getRequestURI();
                String instrumentedString = InstrumentingProxyServlet.this.instrumenter.instrument(body, uri, 1);
                byte[] instrumentedBytes = instrumentedString.getBytes(charset);
                if (InstrumentingProxyServlet.shouldBeGzipEncoded(this.response)) {
                    ByteArrayOutputStream baos = new ByteArrayOutputStream();
                    GZIPOutputStream gzipOutputStream = new GZIPOutputStream(baos);
                    ByteStreams.write((byte[])instrumentedBytes, this.newOutputSupplier(gzipOutputStream));
                    gzipOutputStream.flush();
                    gzipOutputStream.close();
                    in = baos.toByteArray();
                } else {
                    in = instrumentedBytes;
                }
            } else {
                in = remoteResponseBody;
            }
            if (this.response.getHeader("Content-Length") != null) {
                this.response.setContentLength(in.length);
            }
            try {
                ByteStreams.write((byte[])in, this.newOutputSupplier((OutputStream)this.response.getOutputStream()));
                this.response.getOutputStream().flush();
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
            logger.debug("complete");
            this.continuation.complete();
        }

        private OutputSupplier<? extends OutputStream> newOutputSupplier(final OutputStream outputStream) {
            return new OutputSupplier<OutputStream>(){

                public OutputStream getOutput() throws IOException {
                    return outputStream;
                }
            };
        }

        protected void onResponseContent(Buffer content) throws IOException {
            logger.debug("content {}", (Object)content.length());
            content.writeTo((OutputStream)this.baos);
        }

        protected void onResponseStatus(Buffer version, int status, Buffer reason) throws IOException {
            logger.debug("{}, {}, {}", new Object[]{version, status, reason});
            if (reason != null && reason.length() > 0) {
                this.response.setStatus(status, reason.toString());
            } else {
                this.response.setStatus(status);
            }
        }

        protected void onResponseHeader(Buffer name, Buffer value) throws IOException {
            String nameString = name.toString();
            String s = nameString.toLowerCase(Locale.ENGLISH);
            if (!InstrumentingProxyServlet.this._DontProxyHeaders.contains(s) || HttpHeaders.CONNECTION_BUFFER.equals(name) && HttpHeaderValues.CLOSE_BUFFER.equals(value)) {
                logger.debug("{}: {}", (Object)name, (Object)value);
                String filteredHeaderValue = InstrumentingProxyServlet.this.filterResponseHeaderValue(nameString, value.toString(), this.request);
                if (filteredHeaderValue != null && filteredHeaderValue.trim().length() > 0) {
                    logger.debug("{}: (filtered): {}", (Object)name, (Object)filteredHeaderValue);
                    if ("content-type".equals(s)) {
                        this.response.setHeader(nameString, filteredHeaderValue);
                    } else {
                        this.response.addHeader(nameString, filteredHeaderValue);
                    }
                }
            } else {
                logger.debug("{} ! {}", (Object)name, (Object)value);
            }
        }

        protected void onConnectionFailed(Throwable ex) {
            InstrumentingProxyServlet.this.handleOnConnectionFailed(ex, this.request, this.response);
            if (!this.continuation.isInitial()) {
                this.continuation.complete();
            }
        }

        protected void onException(Throwable ex) {
            InstrumentingProxyServlet.this.handleOnException(ex, this.request, this.response);
            if (!this.continuation.isInitial()) {
                this.continuation.complete();
            }
        }

        protected void onExpire() {
            InstrumentingProxyServlet.this.handleOnExpire(this.request, this.response);
            this.continuation.complete();
        }

        private boolean shouldBeInstrumented(HttpServletRequest request, HttpServletResponse response) {
            return response.getStatus() == 200 && request.getRequestURI().toLowerCase(Locale.ENGLISH).endsWith(".js");
        }

        private Charset getCharsetFrom(HttpServletResponse response) {
            String characterEncoding = response.getCharacterEncoding();
            return characterEncoding != null ? Charset.forName(characterEncoding) : Charset.forName("UTF-8");
        }
    }
}

