/*
 * Decompiled with CFR 0.152.
 */
package com.github.timurstrekalov.saga.core.server;

import com.github.timurstrekalov.saga.core.instrumentation.ScriptInstrumenter;
import com.github.timurstrekalov.saga.core.server.InstrumentingProxyServlet;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.ConnectHandler;
import org.eclipse.jetty.server.handler.HandlerCollection;
import org.eclipse.jetty.server.nio.SelectChannelConnector;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstrumentingProxyServer {
    private final Server server;
    private final ScriptInstrumenter instrumenter;
    private static final Logger logger = LoggerFactory.getLogger(InstrumentingProxyServer.class);

    public InstrumentingProxyServer(ScriptInstrumenter instrumenter) {
        this.instrumenter = instrumenter;
        this.server = new Server();
    }

    public int start() {
        SelectChannelConnector connector = new SelectChannelConnector();
        connector.setPort(0);
        this.server.addConnector((Connector)connector);
        HandlerCollection handlers = new HandlerCollection();
        ServletContextHandler context = new ServletContextHandler((HandlerContainer)handlers, "/");
        context.setAttribute(InstrumentingProxyServlet.INSTRUMENTER, (Object)this.instrumenter);
        context.addServlet(new ServletHolder(InstrumentingProxyServlet.class), "/*");
        ConnectHandler connectProxy = new ConnectHandler();
        handlers.addHandler((Handler)connectProxy);
        this.server.setHandler((Handler)handlers);
        try {
            this.server.start();
            logger.info("Proxy server started on port {}", (Object)connector.getLocalPort());
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
        return connector.getLocalPort();
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

