/*
 * Decompiled with CFR 0.152.
 */
package com.github.timurstrekalov.saga.core.reporter;

import com.github.timurstrekalov.saga.core.ReportFormat;
import com.github.timurstrekalov.saga.core.reporter.CoberturaReporter;
import com.github.timurstrekalov.saga.core.reporter.CsvReporter;
import com.github.timurstrekalov.saga.core.reporter.HtmlReporter;
import com.github.timurstrekalov.saga.core.reporter.PdfReporter;
import com.github.timurstrekalov.saga.core.reporter.RawReporter;
import com.github.timurstrekalov.saga.core.reporter.Reporter;
import com.google.common.collect.ImmutableMap;
import java.util.Map;

public final class ReporterFactory {
    private static final Map<ReportFormat, Class<? extends Reporter>> reporters = ImmutableMap.builder().put((Object)ReportFormat.HTML, HtmlReporter.class).put((Object)ReportFormat.RAW, RawReporter.class).put((Object)ReportFormat.CSV, CsvReporter.class).put((Object)ReportFormat.PDF, PdfReporter.class).put((Object)ReportFormat.COBERTURA, CoberturaReporter.class).build();

    private ReporterFactory() {
        throw new UnsupportedOperationException("Non-instantiable");
    }

    public static Reporter reporterFor(ReportFormat reportFormat) {
        if (!reporters.containsKey((Object)reportFormat)) {
            throw new IllegalStateException("Missing reporter for format: " + (Object)((Object)reportFormat));
        }
        try {
            return reporters.get((Object)reportFormat).newInstance();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }
}

