/*
 * Decompiled with CFR 0.152.
 */
package com.github.timurstrekalov.saga.core.model;

import com.github.timurstrekalov.saga.core.Order;
import com.github.timurstrekalov.saga.core.SortBy;
import com.github.timurstrekalov.saga.core.model.ScriptCoverageStatistics;
import com.github.timurstrekalov.saga.core.util.MiscUtil;
import com.github.timurstrekalov.saga.core.util.UriUtil;
import com.google.common.base.Function;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.net.URI;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;

public final class TestRunCoverageStatistics
implements Iterable<ScriptCoverageStatistics> {
    public static final TestRunCoverageStatistics EMPTY = new TestRunCoverageStatistics(null, null);
    public final URI test;
    public final String title;
    private SortBy sortBy;
    private Order order;
    private final Map<URI, ScriptCoverageStatistics> fileStatsMap = Maps.newTreeMap();
    private List<String> sourceDirs;

    public TestRunCoverageStatistics(URI test) {
        this(test, String.format("Coverage report for \"%s\"", test));
    }

    public TestRunCoverageStatistics(URI test, String title) {
        this.test = test;
        this.title = title;
    }

    public String getTestName() {
        return UriUtil.getLastSegmentOrHost(this.test);
    }

    public void add(ScriptCoverageStatistics newStats) {
        URI key = newStats.getFileUri();
        ScriptCoverageStatistics oldStats = this.fileStatsMap.get(key);
        if (oldStats != null) {
            this.fileStatsMap.put(key, ScriptCoverageStatistics.merge(newStats, oldStats));
        } else {
            this.fileStatsMap.put(key, newStats);
        }
    }

    public List<ScriptCoverageStatistics> getFileStats() {
        LinkedList result = Lists.newLinkedList(this.fileStatsMap.values());
        Collections.sort(result, new Comparator<ScriptCoverageStatistics>(){

            @Override
            public int compare(ScriptCoverageStatistics s1, ScriptCoverageStatistics s2) {
                return (TestRunCoverageStatistics.this.getOrder() == Order.ASC ? 1 : -1) * TestRunCoverageStatistics.this.getSortBy().compare(s1, s2);
            }
        });
        return result;
    }

    public Collection<ScriptCoverageStatistics> getFileStatsWithSeparateFileOnly() {
        return Collections2.filter(this.getFileStats(), (Predicate)new Predicate<ScriptCoverageStatistics>(){

            public boolean apply(ScriptCoverageStatistics stats) {
                return stats.isSeparateFile();
            }
        });
    }

    public int getTotalStatements() {
        return MiscUtil.sum(this.fileStatsMap.values(), new Function<ScriptCoverageStatistics, Integer>(){

            public Integer apply(ScriptCoverageStatistics input) {
                return input.getStatements();
            }
        });
    }

    public int getTotalExecuted() {
        return MiscUtil.sum(this.fileStatsMap.values(), new Function<ScriptCoverageStatistics, Integer>(){

            public Integer apply(ScriptCoverageStatistics input) {
                return input.getExecuted();
            }
        });
    }

    public int getTotalCoverage() {
        return MiscUtil.toCoverage(this.getTotalStatements(), this.getTotalExecuted());
    }

    public double getTotalCoverageRate() {
        return MiscUtil.toCoverageRate(this.getTotalStatements(), this.getTotalExecuted());
    }

    public boolean getHasStatements() {
        return this.getTotalStatements() > 0;
    }

    public String getBarColor() {
        return MiscUtil.getColor(this.getTotalCoverage());
    }

    public int getBarColorAsArgb() {
        return MiscUtil.getColorAsArgb(this.getTotalCoverage());
    }

    @Override
    public Iterator<ScriptCoverageStatistics> iterator() {
        return this.getFileStats().iterator();
    }

    public void setSortBy(SortBy sortBy) {
        this.sortBy = sortBy;
    }

    public SortBy getSortBy() {
        return this.sortBy;
    }

    public void setOrder(Order order) {
        this.order = order;
    }

    public Order getOrder() {
        return this.order;
    }

    public void setSourceDirs(List<String> sourceDirs) {
        this.sourceDirs = sourceDirs;
    }

    public List<String> getSourceDirs() {
        return this.sourceDirs;
    }
}

