/*
 * Decompiled with CFR 0.152.
 */
package com.github.timurstrekalov.saga.core.model;

import com.github.timurstrekalov.saga.core.model.LineCoverageRecord;
import com.github.timurstrekalov.saga.core.model.ScriptCoverageStatistics;
import com.google.common.base.Objects;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.net.URI;
import java.util.ArrayList;
import java.util.Map;
import java.util.Scanner;
import java.util.SortedSet;

public final class ScriptData {
    private final URI sourceUri;
    private final String sourceCode;
    private final boolean separateFile;
    private final SortedSet<Integer> linesWithStatements = Sets.newTreeSet();
    private String instrumentedSourceCode;

    public ScriptData(URI sourceUri, String sourceCode, boolean separateFile) {
        this.sourceUri = sourceUri;
        this.sourceCode = sourceCode;
        this.separateFile = separateFile;
    }

    public void addExecutableLine(Integer lineNr) {
        this.linesWithStatements.add(lineNr);
    }

    public URI getSourceUri() {
        return this.sourceUri;
    }

    public String getSourceUriAsString() {
        return this.sourceUri.toString();
    }

    public String getSourceCode() {
        return this.sourceCode;
    }

    public SortedSet<Integer> getLineNumbersOfAllStatements() {
        return Sets.newTreeSet(this.linesWithStatements);
    }

    public int getNumberOfStatements() {
        return this.linesWithStatements.size();
    }

    private boolean hasStatement(int lineNr) {
        return this.linesWithStatements.contains(lineNr);
    }

    public int getLineNumberOfFirstStatement() {
        return this.linesWithStatements.first();
    }

    public void setInstrumentedSourceCode(String instrumentedSourceCode) {
        this.instrumentedSourceCode = instrumentedSourceCode;
    }

    public String getInstrumentedSourceCode() {
        return this.instrumentedSourceCode;
    }

    public boolean isSeparateFile() {
        return this.separateFile;
    }

    public ScriptCoverageStatistics generateScriptCoverageStatistics(URI baseUri, Map<String, Long> coverageData) {
        Scanner in = new Scanner(this.getSourceCode());
        ArrayList lineCoverageRecords = Lists.newArrayList();
        if (!this.linesWithStatements.isEmpty()) {
            int lineNr;
            for (lineNr = 1; lineNr < this.getLineNumberOfFirstStatement() && in.hasNext(); ++lineNr) {
                lineCoverageRecords.add(new LineCoverageRecord(lineNr, -1, in.nextLine()));
            }
            lineNr = this.getLineNumberOfFirstStatement();
            while (in.hasNext()) {
                String line = in.nextLine();
                Long coverageEntry = coverageData.get(String.valueOf(lineNr));
                int timesLineExecuted = coverageEntry == null ? (this.hasStatement(lineNr) ? 0 : -1) : coverageEntry.intValue();
                lineCoverageRecords.add(new LineCoverageRecord(lineNr, timesLineExecuted, line));
                ++lineNr;
            }
        } else {
            int lineNr = 1;
            while (in.hasNext()) {
                lineCoverageRecords.add(new LineCoverageRecord(lineNr, -1, in.nextLine()));
                ++lineNr;
            }
        }
        return new ScriptCoverageStatistics(baseUri, this.getSourceUri(), lineCoverageRecords, this.isSeparateFile());
    }

    public String toString() {
        return Objects.toStringHelper((Object)this).add("sourceUri", (Object)this.sourceUri).add("separateFile", this.separateFile).toString();
    }
}

