/*
 * Decompiled with CFR 0.152.
 */
package com.github.timurstrekalov.saga.core.model;

import com.github.timurstrekalov.saga.core.model.LineCoverageRecord;
import com.github.timurstrekalov.saga.core.util.MiscUtil;
import com.github.timurstrekalov.saga.core.util.ResourceUtil;
import com.github.timurstrekalov.saga.core.util.UriUtil;
import com.google.common.base.Function;
import com.google.common.base.Preconditions;
import com.google.common.base.Predicate;
import com.google.common.collect.Collections2;
import com.google.common.collect.Lists;
import com.google.common.hash.Hashing;
import java.io.File;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;

public final class ScriptCoverageStatistics {
    private final URI baseUri;
    private final URI fileUri;
    private final List<LineCoverageRecord> lineCoverageRecords;
    private final boolean separateFile;
    private final String parentName;
    private final String id;

    public ScriptCoverageStatistics(URI baseUri, URI fileUri, List<LineCoverageRecord> lineCoverageRecords, boolean separateFile) {
        this.baseUri = baseUri;
        this.fileUri = fileUri;
        this.separateFile = separateFile;
        this.parentName = new File(this.getRelativeName()).getParent();
        this.id = this.generateId();
        this.lineCoverageRecords = lineCoverageRecords;
    }

    private String generateId() {
        return Hashing.md5().hashString((CharSequence)this.fileUri.toString(), Charset.defaultCharset()).toString();
    }

    public List<LineCoverageRecord> getLineCoverageRecords() {
        return this.lineCoverageRecords;
    }

    public Collection<LineCoverageRecord> getExecutableLineCoverageRecords() {
        return Collections2.filter(this.lineCoverageRecords, (Predicate)new Predicate<LineCoverageRecord>(){

            public boolean apply(LineCoverageRecord record) {
                return record.isExecutable();
            }
        });
    }

    public int getStatements() {
        return Collections2.filter(this.lineCoverageRecords, (Predicate)new Predicate<LineCoverageRecord>(){

            public boolean apply(LineCoverageRecord input) {
                return input.isExecutable();
            }
        }).size();
    }

    public int getExecuted() {
        return MiscUtil.sum(this.lineCoverageRecords, new Function<LineCoverageRecord, Integer>(){

            public Integer apply(LineCoverageRecord input) {
                return input.getTimesExecuted() > 0 ? 1 : 0;
            }
        });
    }

    public int getCoverage() {
        return MiscUtil.toCoverage(this.getStatements(), this.getExecuted());
    }

    public double getCoverageRate() {
        return MiscUtil.toCoverageRate(this.getStatements(), this.getExecuted());
    }

    public boolean getHasStatements() {
        return this.getStatements() > 0;
    }

    public String getBarColor() {
        return MiscUtil.getColor(this.getCoverage());
    }

    public int getBarColorAsArgb() {
        return MiscUtil.getColorAsArgb(this.getCoverage());
    }

    public static ScriptCoverageStatistics merge(ScriptCoverageStatistics s1, ScriptCoverageStatistics s2) {
        List<LineCoverageRecord> r1 = s1.getLineCoverageRecords();
        List<LineCoverageRecord> r2 = s2.getLineCoverageRecords();
        Preconditions.checkArgument((boolean)s1.fileUri.equals(s2.fileUri), (String)"Got different file names: %s and %s", (Object[])new Object[]{s1, s2});
        Preconditions.checkArgument((r1.size() == r2.size() ? 1 : 0) != 0, (String)"Got different numbers of line coverage records: %s and %s", (Object[])new Object[]{s1, s2});
        LinkedList mergedRecords = Lists.newLinkedList();
        for (int i = 0; i < r1.size(); ++i) {
            LineCoverageRecord l1 = r1.get(i);
            LineCoverageRecord l2 = r2.get(i);
            try {
                mergedRecords.add(LineCoverageRecord.merge(l1, l2));
                continue;
            }
            catch (Exception e) {
                throw new RuntimeException("Error merging " + s1.fileUri + " and " + s2.fileUri, e);
            }
        }
        return new ScriptCoverageStatistics(s1.baseUri, s1.fileUri, mergedRecords, s1.separateFile);
    }

    public URI getFileUri() {
        return this.fileUri;
    }

    public String getFileName() {
        return UriUtil.getLastSegmentOrHost(this.fileUri);
    }

    public String getFullName() {
        return UriUtil.getPath(this.fileUri);
    }

    public String getRelativeName() {
        return this.isSeparateFile() ? ResourceUtil.getRelativePath(this.fileUri.toString(), this.baseUri.toString(), "/") : this.fileUri.toString();
    }

    public String getParentName() {
        return this.parentName;
    }

    public String getId() {
        return this.id;
    }

    public boolean isSeparateFile() {
        return this.separateFile;
    }

    public String toString() {
        return this.fileUri.toString();
    }
}

