/*
 * Decompiled with CFR 0.152.
 */
package com.github.timurstrekalov.saga.core.instrumentation;

import com.github.timurstrekalov.saga.core.model.ScriptData;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import net.sourceforge.htmlunit.corejs.javascript.Node;
import net.sourceforge.htmlunit.corejs.javascript.ast.AstNode;
import net.sourceforge.htmlunit.corejs.javascript.ast.Block;
import net.sourceforge.htmlunit.corejs.javascript.ast.ElementGet;
import net.sourceforge.htmlunit.corejs.javascript.ast.ExpressionStatement;
import net.sourceforge.htmlunit.corejs.javascript.ast.IfStatement;
import net.sourceforge.htmlunit.corejs.javascript.ast.LabeledStatement;
import net.sourceforge.htmlunit.corejs.javascript.ast.Loop;
import net.sourceforge.htmlunit.corejs.javascript.ast.Name;
import net.sourceforge.htmlunit.corejs.javascript.ast.NodeVisitor;
import net.sourceforge.htmlunit.corejs.javascript.ast.NumberLiteral;
import net.sourceforge.htmlunit.corejs.javascript.ast.StringLiteral;
import net.sourceforge.htmlunit.corejs.javascript.ast.SwitchCase;
import net.sourceforge.htmlunit.corejs.javascript.ast.UnaryExpression;
import net.sourceforge.htmlunit.corejs.javascript.ast.VariableDeclaration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class InstrumentingNodeVisitor
implements NodeVisitor {
    private static final Logger logger = LoggerFactory.getLogger(InstrumentingNodeVisitor.class);
    private final ScriptData data;
    private final int lineNumberOffset;

    public InstrumentingNodeVisitor(ScriptData data, int lineNumberOffset) {
        this.data = data;
        this.lineNumberOffset = lineNumberOffset;
    }

    public boolean visit(AstNode node) {
        this.handleNumberLiteralBug(node);
        if (this.isExecutableBlock(node)) {
            this.addInstrumentationSnippetFor(node);
        }
        return true;
    }

    private void handleNumberLiteralBug(AstNode node) {
        if (node.getType() == 40) {
            NumberLiteral numberLiteral = (NumberLiteral)node;
            numberLiteral.setValue(this.getValue(numberLiteral));
        }
    }

    private String getValue(NumberLiteral literal) {
        if (Math.floor(literal.getNumber()) == literal.getNumber()) {
            return Long.toString((long)literal.getNumber());
        }
        return Double.toString(literal.getNumber());
    }

    private boolean isExecutableBlock(AstNode node) {
        AstNode parent = node.getParent();
        if (parent == null) {
            return false;
        }
        int type = node.getType();
        int parentType = parent.getType();
        return type == 114 || type == 119 || type == 118 || type == 117 || type == 121 || type == 120 || type == 81 || type == 50 || type == 115 || type == 112 || type == 134 || type == 133 || type == 4 || type == 109 && (parentType == 136 || parentType == 129) || type == 122 && node.getClass() == VariableDeclaration.class && parentType != 119;
    }

    private void addInstrumentationSnippetFor(AstNode node) {
        AstNode parent = node.getParent();
        int type = node.getType();
        int parentType = parent.getType();
        if (type == 117 || type == 119 || type == 118) {
            this.fixLoops((Loop)node);
        }
        if (type == 112) {
            this.fixIf((IfStatement)node);
        }
        if (type == 115) {
            this.handleSwitchCase((SwitchCase)node);
        } else if (type == 112 && parentType == 112) {
            IfStatement elseIfStatement = (IfStatement)node;
            IfStatement ifStatement = (IfStatement)parent;
            if (ifStatement.getElsePart() == elseIfStatement) {
                this.flattenElseIf(elseIfStatement, ifStatement);
                this.data.addExecutableLine(this.getActualLineNumber(node));
            }
        } else if (parentType != 115) {
            if (parent.getClass() == LabeledStatement.class) {
                return;
            }
            if (parent.hasChildren()) {
                parent.addChildBefore((Node)this.newInstrumentationNode(this.getActualLineNumber(node)), (Node)node);
            } else {
                Block block = this.newInstrumentedBlock(node);
                if (parentType == 112) {
                    IfStatement ifStatement = (IfStatement)parent;
                    if (ifStatement.getThenPart() == node) {
                        ifStatement.setThenPart((AstNode)block);
                    } else if (ifStatement.getElsePart() == node) {
                        ifStatement.setElsePart((AstNode)block);
                    }
                } else if (parentType == 117 || parentType == 119 || parentType == 118) {
                    ((Loop)parent).setBody((AstNode)block);
                } else {
                    logger.warn("Cannot handle node with parent that has no children, parent class: {}, parent source:\n{}", parent.getClass(), (Object)parent.toSource());
                }
            }
            this.data.addExecutableLine(this.getActualLineNumber(node));
        }
    }

    private void fixLoops(Loop loop) {
        if (loop.getBody().getType() == 128) {
            loop.setBody((AstNode)new Block());
        }
    }

    private void fixIf(IfStatement ifStatement) {
        if (ifStatement.getThenPart().getType() == 128) {
            ifStatement.setThenPart((AstNode)new Block());
        }
    }

    private int getActualLineNumber(AstNode node) {
        return node.getLineno() - this.lineNumberOffset;
    }

    private Block newInstrumentedBlock(AstNode node) {
        Block block = new Block();
        block.addChild(node);
        block.addChildBefore((Node)this.newInstrumentationNode(this.getActualLineNumber(node)), (Node)node);
        return block;
    }

    private void handleSwitchCase(SwitchCase switchCase) {
        if (switchCase.getStatements() == null) {
            return;
        }
        ArrayList newStatements = Lists.newArrayList();
        for (AstNode statement : switchCase.getStatements()) {
            int lineNr = this.getActualLineNumber(statement);
            this.data.addExecutableLine(lineNr);
            newStatements.add(this.newInstrumentationNode(lineNr));
            newStatements.add(statement);
        }
        switchCase.setStatements((List)newStatements);
    }

    private void flattenElseIf(IfStatement elseIfStatement, IfStatement ifStatement) {
        Block block = new Block();
        block.addChild((AstNode)elseIfStatement);
        ifStatement.setElsePart((AstNode)block);
        int lineNr = this.getActualLineNumber((AstNode)elseIfStatement);
        this.data.addExecutableLine(lineNr);
        block.addChildBefore((Node)this.newInstrumentationNode(lineNr), (Node)elseIfStatement);
    }

    private AstNode newInstrumentationNode(int lineNr) {
        ExpressionStatement instrumentationNode = new ExpressionStatement();
        UnaryExpression inc = new UnaryExpression();
        inc.setIsPostfix(true);
        inc.setOperator(106);
        ElementGet outer = new ElementGet();
        ElementGet inner = new ElementGet();
        outer.setTarget((AstNode)inner);
        Name covDataVar = new Name();
        covDataVar.setIdentifier("__saga_coverage_data");
        inner.setTarget((AstNode)covDataVar);
        StringLiteral fileName = new StringLiteral();
        fileName.setValue(this.data.getSourceUriAsString());
        fileName.setQuoteCharacter('\'');
        inner.setElement((AstNode)fileName);
        NumberLiteral index = new NumberLiteral();
        index.setNumber((double)lineNr);
        index.setValue(Integer.toString(lineNr));
        outer.setElement((AstNode)index);
        inc.setOperand((AstNode)outer);
        instrumentationNode.setExpression((AstNode)inc);
        instrumentationNode.setHasResult();
        return instrumentationNode;
    }
}

