/*
 * Decompiled with CFR 0.152.
 */
package com.github.timurstrekalov.saga.core.instrumentation;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.ScriptPreProcessor;
import com.gargoylesoftware.htmlunit.WebClient;
import com.github.timurstrekalov.saga.core.cfg.Config;
import com.github.timurstrekalov.saga.core.htmlunit.InstrumentingPreProcessor;
import com.github.timurstrekalov.saga.core.htmlunit.WebClientFactory;
import com.github.timurstrekalov.saga.core.instrumentation.HtmlUnitBasedScriptInstrumenter;
import com.github.timurstrekalov.saga.core.instrumentation.InstrumentingBrowser;
import com.github.timurstrekalov.saga.core.instrumentation.ScriptInstrumenter;
import com.github.timurstrekalov.saga.core.model.ScriptData;
import com.google.common.base.Function;
import com.google.common.collect.Maps;
import java.io.File;
import java.net.URL;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.htmlunit.HtmlUnitDriver;

public final class HtmlUnitInstrumentingBrowser
implements InstrumentingBrowser {
    private final Config config;
    private Driver driver;
    private ScriptInstrumenter instrumenter;
    private InstrumentingPreProcessor preProcessor;
    private boolean initialized = false;

    public HtmlUnitInstrumentingBrowser(Config config) {
        this.config = config;
        this.driver = new Driver(config.getBrowserVersion());
        this.initialize();
    }

    public HtmlUnitInstrumentingBrowser(Config config, Driver driver) {
        this.config = config;
        this.driver = driver;
    }

    private void initialize() {
        this.instrumenter = new HtmlUnitBasedScriptInstrumenter(this.config);
        this.instrumenter.setIgnorePatterns(this.config.getIgnorePatterns());
        if (this.config.isOutputInstrumentedFiles()) {
            this.instrumenter.setInstrumentedFileDirectory(this.config.getInstrumentedFileDirectory());
        }
        this.preProcessor = new InstrumentingPreProcessor(this.instrumenter);
        this.driver.init(this.config, this.preProcessor);
        this.driver.enableInstrumentation();
        this.initialized = true;
    }

    @Override
    public String instrument(String sourceCode, String sourceName, int lineNumber) {
        return this.instrumenter.instrument(sourceCode, sourceName, lineNumber);
    }

    @Override
    public void setIgnorePatterns(Collection<Pattern> ignorePatterns) {
        this.instrumenter.setIgnorePatterns(ignorePatterns);
    }

    @Override
    public void setInstrumentedFileDirectory(File instrumentedFileDirectory) {
        this.instrumenter.setInstrumentedFileDirectory(instrumentedFileDirectory);
    }

    @Override
    public List<ScriptData> getScriptDataList() {
        return this.instrumenter.getScriptDataList();
    }

    @Override
    public void get(String url) {
        if (!this.initialized) {
            this.initialize();
        }
        this.driver.get(url);
    }

    @Override
    public void quit() {
        this.driver.quit();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Map<String, Map<String, Long>> extractCoverageDataVariable() {
        try {
            this.driver.disableInstrumentation();
            Map data = (Map)this.driver.executeScript("return window.__saga_coverage_data", new Object[0]);
            if (data == null) {
                Map<String, Map<String, Long>> map = null;
                return map;
            }
            Map map = Maps.transformValues((Map)data, (Function)new Function<Map<Long, Long>, Map<String, Long>>(){

                public Map<String, Long> apply(Map<Long, Long> input) {
                    HashMap result = Maps.newHashMap();
                    for (Map.Entry<Long, Long> e : input.entrySet()) {
                        result.put(String.valueOf(e.getKey()), e.getValue());
                    }
                    return result;
                }
            });
            return map;
        }
        finally {
            this.driver.enableInstrumentation();
        }
    }

    public static class Driver
    extends HtmlUnitDriver {
        private Config config;
        private InstrumentingPreProcessor preProcessor;

        public Driver(BrowserVersion browserVersion) {
            super(browserVersion);
            this.setJavascriptEnabled(true);
        }

        public Driver(Capabilities caps) {
            super(caps);
            this.setJavascriptEnabled(true);
        }

        private void init(Config config, InstrumentingPreProcessor preProcessor) {
            this.config = config;
            this.preProcessor = preProcessor;
        }

        protected WebClient newWebClient(BrowserVersion version) {
            return WebClientFactory.newInstance(version);
        }

        protected void get(URL fullUrl) {
            super.get(fullUrl);
            this.getWebClient().waitForBackgroundJavaScript(this.config != null ? this.config.getBackgroundJavaScriptTimeout() : 300000L);
        }

        public void enableInstrumentation() {
            this.getWebClient().setScriptPreProcessor((ScriptPreProcessor)this.preProcessor);
        }

        public void disableInstrumentation() {
            this.getWebClient().setScriptPreProcessor(null);
        }
    }
}

