/*
 * Decompiled with CFR 0.152.
 */
package com.github.timurstrekalov.saga.core.instrumentation;

import com.github.timurstrekalov.saga.core.cfg.Config;
import com.github.timurstrekalov.saga.core.instrumentation.InstrumentingNodeVisitor;
import com.github.timurstrekalov.saga.core.instrumentation.ScriptInstrumenter;
import com.github.timurstrekalov.saga.core.model.ScriptData;
import com.github.timurstrekalov.saga.core.util.UriUtil;
import com.google.common.base.Predicate;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import com.google.common.hash.Hashing;
import com.google.common.io.ByteStreams;
import com.google.common.io.CharStreams;
import com.google.common.io.Files;
import com.google.common.io.InputSupplier;
import com.google.common.io.OutputSupplier;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URI;
import java.nio.charset.Charset;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.sourceforge.htmlunit.corejs.javascript.Parser;
import net.sourceforge.htmlunit.corejs.javascript.ast.AstRoot;
import net.sourceforge.htmlunit.corejs.javascript.ast.NodeVisitor;
import org.codehaus.plexus.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public final class HtmlUnitBasedScriptInstrumenter
implements ScriptInstrumenter {
    private static final String INITIALIZING_CODE = String.format("%s = window.%s || {};%n", "__saga_coverage_data", "__saga_coverage_data");
    private static final String ARRAY_INITIALIZER = String.format("    %s['%%s'][%%d] = 0;%n", "__saga_coverage_data");
    public static final String COMPLETION_MONITOR;
    private static final AtomicInteger evalCounter;
    private static final Logger logger;
    private static final Pattern inlineScriptRe;
    private static final Pattern evalRe;
    private static final Pattern nonFileRe;
    private static final ConcurrentMap<URI, ScriptData> instrumentedScriptCache;
    private static final Set<URI> writtenToDisk;
    private final Config config;
    private final List<ScriptData> scriptDataList = Collections.synchronizedList(Lists.newLinkedList());
    private Collection<Pattern> ignorePatterns;
    private File instrumentedFileDirectory;

    public HtmlUnitBasedScriptInstrumenter(Config config) {
        this.config = config;
        this.setIgnorePatterns(config.getIgnorePatterns());
    }

    @Override
    public String instrument(String sourceCode, String sourceName, int lineNumber) {
        try {
            String normalizedSourceName = HtmlUnitBasedScriptInstrumenter.handleEvals(HtmlUnitBasedScriptInstrumenter.handleInvalidUriChars(HtmlUnitBasedScriptInstrumenter.handleInlineScripts(sourceName)));
            if (this.shouldIgnore(normalizedSourceName)) {
                return sourceCode;
            }
            boolean separateFile = HtmlUnitBasedScriptInstrumenter.isSeparateFile(sourceName, normalizedSourceName);
            URI sourceUri = URI.create(normalizedSourceName).normalize();
            if (this.config.isCacheInstrumentedCode() && instrumentedScriptCache.containsKey(sourceUri)) {
                ScriptData data = (ScriptData)instrumentedScriptCache.get(sourceUri);
                this.scriptDataList.add(data);
                return data.getInstrumentedSourceCode();
            }
            ScriptData data = this.addNewScriptData(sourceCode, separateFile, sourceUri);
            String instrumentedCode = this.instrument(lineNumber, data);
            data.setInstrumentedSourceCode(instrumentedCode);
            this.maybeCache(sourceUri, data);
            this.maybeWriteInstrumentedCodeToDisk(separateFile, sourceUri, instrumentedCode);
            return instrumentedCode;
        }
        catch (RuntimeException e) {
            logger.error("Exception caught while instrumenting code", (Throwable)e);
            return sourceCode;
        }
    }

    private String instrument(int lineNumber, ScriptData data) {
        Parser parser = new Parser();
        String sourceUriAsString = data.getSourceUriAsString();
        AstRoot root = parser.parse(data.getSourceCode(), sourceUriAsString, lineNumber);
        root.visit((NodeVisitor)new InstrumentingNodeVisitor(data, lineNumber - 1));
        String treeSource = root.toSource();
        StringBuilder buf = new StringBuilder(INITIALIZING_CODE.length() + data.getNumberOfStatements() * ARRAY_INITIALIZER.length() + treeSource.length());
        buf.append(COMPLETION_MONITOR);
        buf.append(INITIALIZING_CODE);
        buf.append(String.format("if(!%s['%s']) {%n", "__saga_coverage_data", sourceUriAsString));
        buf.append(String.format("    %s['%s'] = {};%n", "__saga_coverage_data", sourceUriAsString));
        for (Integer i : data.getLineNumbersOfAllStatements()) {
            buf.append(String.format(ARRAY_INITIALIZER, sourceUriAsString, i));
        }
        buf.append(String.format("}%n", new Object[0]));
        buf.append(treeSource);
        return buf.toString();
    }

    private ScriptData addNewScriptData(String sourceCode, boolean separateFile, URI sourceUri) {
        ScriptData data = new ScriptData(sourceUri, sourceCode, separateFile);
        this.scriptDataList.add(data);
        return data;
    }

    private static boolean isSeparateFile(String sourceName, String normalizedSourceName) {
        return normalizedSourceName.equals(sourceName) && !nonFileRe.matcher(normalizedSourceName).matches();
    }

    private static String handleInlineScripts(String sourceName) {
        return inlineScriptRe.matcher(sourceName).replaceAll("$1__from_$2_$3_to_$4_$5");
    }

    private static String handleEvals(String sourceName) {
        Matcher matcher = evalRe.matcher(sourceName);
        if (matcher.find()) {
            return sourceName + "(" + evalCounter.getAndIncrement() + ")";
        }
        return sourceName;
    }

    private static String handleInvalidUriChars(String sourceName) {
        StringBuilder buf = new StringBuilder();
        int indexOfQueryDelimiter = sourceName.indexOf(63);
        int indexOfFragmentDelimiter = sourceName.indexOf(35);
        if (indexOfQueryDelimiter != -1) {
            buf.append(sourceName.substring(0, indexOfQueryDelimiter)).append('?');
        } else if (indexOfFragmentDelimiter != -1) {
            buf.append(sourceName.substring(0, indexOfFragmentDelimiter)).append('#');
        } else {
            buf.append(sourceName);
        }
        if (indexOfQueryDelimiter != -1) {
            int lastIndex = indexOfFragmentDelimiter == -1 ? sourceName.length() : indexOfFragmentDelimiter;
            String queryString = sourceName.substring(indexOfQueryDelimiter + 1, lastIndex);
            buf.append(queryString.replaceAll("\\?", "%3F"));
        }
        if (indexOfFragmentDelimiter != -1) {
            String fragment = sourceName.substring(indexOfFragmentDelimiter + 1);
            buf.append(fragment.replaceAll("#", "%23"));
        }
        return buf.toString();
    }

    private void maybeCache(URI sourceUri, ScriptData data) {
        if (this.config.isCacheInstrumentedCode()) {
            instrumentedScriptCache.putIfAbsent(sourceUri, data);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void maybeWriteInstrumentedCodeToDisk(boolean separateFile, URI sourceUri, String instrumentedCode) {
        if (this.config.isOutputInstrumentedFiles() && separateFile) {
            Set<URI> set = writtenToDisk;
            synchronized (set) {
                try {
                    if (!writtenToDisk.contains(sourceUri)) {
                        String parent = UriUtil.getParent(sourceUri);
                        String fileName = UriUtil.getLastSegmentOrHost(sourceUri);
                        File fileOutputDir = new File(this.instrumentedFileDirectory, Hashing.md5().hashString((CharSequence)parent).toString());
                        FileUtils.mkdir((String)fileOutputDir.getAbsolutePath());
                        File outputFile = new File(fileOutputDir, fileName);
                        logger.info("Writing instrumented file: {}", (Object)outputFile.getAbsolutePath());
                        ByteStreams.write((byte[])instrumentedCode.getBytes("UTF-8"), (OutputSupplier)Files.newOutputStreamSupplier((File)outputFile));
                        writtenToDisk.add(sourceUri);
                    }
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        }
    }

    private boolean shouldIgnore(final String sourceName) {
        return this.ignorePatterns != null && Iterables.any(this.ignorePatterns, (Predicate)new Predicate<Pattern>(){

            public boolean apply(Pattern input) {
                return input.matcher(sourceName).matches();
            }
        });
    }

    @Override
    public List<ScriptData> getScriptDataList() {
        return this.scriptDataList;
    }

    @Override
    public void setIgnorePatterns(Collection<Pattern> ignorePatterns) {
        this.ignorePatterns = ignorePatterns;
    }

    @Override
    public void setInstrumentedFileDirectory(File instrumentedFileDirectory) {
        this.instrumentedFileDirectory = instrumentedFileDirectory;
    }

    static {
        evalCounter = new AtomicInteger();
        logger = LoggerFactory.getLogger(HtmlUnitBasedScriptInstrumenter.class);
        inlineScriptRe = Pattern.compile("script in (.+) from \\((\\d+), (\\d+)\\) to \\((\\d+), (\\d+)\\)");
        evalRe = Pattern.compile("(.+)(#|%23)(\\d+\\(eval\\))");
        nonFileRe = Pattern.compile("JavaScriptStringJob");
        instrumentedScriptCache = Maps.newConcurrentMap();
        writtenToDisk = Sets.newHashSet();
        try {
            COMPLETION_MONITOR = CharStreams.toString((InputSupplier)new InputSupplier<Reader>(){

                public Reader getInput() throws IOException {
                    return new InputStreamReader(HtmlUnitBasedScriptInstrumenter.class.getResourceAsStream("/completion_monitor.js"), Charset.forName("UTF-8"));
                }
            });
        }
        catch (IOException e) {
            throw new RuntimeException("Could not initialize instrumenter", e);
        }
    }
}

