/*
 * Decompiled with CFR 0.152.
 */
package com.github.timurstrekalov.saga.core.instrumentation;

import com.github.timurstrekalov.saga.core.cfg.Config;
import com.github.timurstrekalov.saga.core.instrumentation.HtmlUnitBasedScriptInstrumenter;
import com.github.timurstrekalov.saga.core.instrumentation.InstrumentingBrowser;
import com.github.timurstrekalov.saga.core.instrumentation.ScriptInstrumenter;
import com.github.timurstrekalov.saga.core.model.ScriptData;
import com.github.timurstrekalov.saga.core.server.InstrumentingProxyServer;
import com.github.timurstrekalov.saga.core.webdriver.SafeJavascriptWait;
import com.github.timurstrekalov.saga.core.webdriver.WebDriverUtils;
import com.google.common.base.Predicate;
import java.io.File;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.regex.Pattern;
import org.openqa.selenium.Capabilities;
import org.openqa.selenium.JavascriptExecutor;
import org.openqa.selenium.Proxy;
import org.openqa.selenium.WebDriver;
import org.openqa.selenium.remote.DesiredCapabilities;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GenericInstrumentingBrowser
implements InstrumentingBrowser {
    private static final Logger logger = LoggerFactory.getLogger(GenericInstrumentingBrowser.class);
    private final Config config;
    private final WebDriver driver;
    private final ScriptInstrumenter instrumenter;
    private final int proxyServerPort;

    public GenericInstrumentingBrowser(Config config) {
        this.config = config;
        this.instrumenter = new HtmlUnitBasedScriptInstrumenter(config);
        InstrumentingProxyServer proxyServer = new InstrumentingProxyServer(this.instrumenter);
        this.proxyServerPort = proxyServer.start();
        this.driver = this.newDriver(this.getWebDriverClass());
    }

    @Override
    public void get(String url) {
        this.driver.get(url);
        JavascriptExecutor js = (JavascriptExecutor)this.driver;
        WebDriverUtils.waitForWindowJavaScriptVariableToBePresent(js, "__saga");
        new SafeJavascriptWait(js).withTimeout(this.config.getBackgroundJavaScriptTimeout(), TimeUnit.MILLISECONDS).until((Predicate)new Predicate<JavascriptExecutor>(){

            public boolean apply(JavascriptExecutor input) {
                logger.debug("Waiting for test runner to finish");
                return Boolean.TRUE.equals(input.executeScript("return __saga.completed()", new Object[0]));
            }
        });
    }

    @Override
    public void quit() {
        this.driver.quit();
    }

    @Override
    public Map<String, Map<String, Long>> extractCoverageDataVariable() {
        JavascriptExecutor js = (JavascriptExecutor)this.driver;
        return (Map)js.executeScript("return window.__saga_coverage_data", new Object[0]);
    }

    @Override
    public String instrument(String sourceCode, String sourceName, int lineNumber) {
        return this.instrumenter.instrument(sourceCode, sourceName, lineNumber);
    }

    @Override
    public void setIgnorePatterns(Collection<Pattern> ignorePatterns) {
        this.instrumenter.setIgnorePatterns(ignorePatterns);
    }

    @Override
    public void setInstrumentedFileDirectory(File instrumentedFileDirectory) {
        this.instrumenter.setInstrumentedFileDirectory(instrumentedFileDirectory);
    }

    @Override
    public List<ScriptData> getScriptDataList() {
        return this.instrumenter.getScriptDataList();
    }

    private WebDriver newDriver(Class<WebDriver> driverClass) {
        try {
            try {
                return driverClass.getConstructor(Capabilities.class).newInstance(this.getCapabilities());
            }
            catch (NoSuchMethodException e) {
                return driverClass.newInstance();
            }
        }
        catch (Exception e) {
            throw new RuntimeException("Could not create driver", e);
        }
    }

    private Capabilities getCapabilities() {
        String proxyUrl = "localhost:" + this.proxyServerPort;
        Proxy proxy = new Proxy().setProxyType(Proxy.ProxyType.MANUAL).setHttpProxy(proxyUrl).setSslProxy(proxyUrl);
        DesiredCapabilities desiredCapabilities = new DesiredCapabilities(this.config.getWebDriverCapabilities());
        desiredCapabilities.setCapability("proxy", (Object)proxy);
        desiredCapabilities.setJavascriptEnabled(true);
        return desiredCapabilities;
    }

    private Class<WebDriver> getWebDriverClass() {
        Class<WebDriver> driverClass;
        try {
            driverClass = Class.forName(this.config.getWebDriverClassName());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException("Could not load class for the driver", e);
        }
        return driverClass;
    }
}

