/*
 * Decompiled with CFR 0.152.
 */
package com.github.timurstrekalov.saga.core.htmlunit;

import com.gargoylesoftware.htmlunit.AjaxController;
import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.gargoylesoftware.htmlunit.HttpWebConnection;
import com.gargoylesoftware.htmlunit.IncorrectnessListener;
import com.gargoylesoftware.htmlunit.NicelyResynchronizingAjaxController;
import com.gargoylesoftware.htmlunit.SilentCssErrorHandler;
import com.gargoylesoftware.htmlunit.WebClient;
import com.gargoylesoftware.htmlunit.WebConnection;
import com.gargoylesoftware.htmlunit.WebRequest;
import com.gargoylesoftware.htmlunit.WebResponse;
import com.gargoylesoftware.htmlunit.WebResponseData;
import com.gargoylesoftware.htmlunit.html.HTMLParserListener;
import com.gargoylesoftware.htmlunit.javascript.JavaScriptErrorListener;
import com.github.timurstrekalov.saga.core.cfg.Config;
import com.github.timurstrekalov.saga.core.htmlunit.QuietHtmlParserListener;
import com.github.timurstrekalov.saga.core.htmlunit.QuietIncorrectnessListener;
import com.github.timurstrekalov.saga.core.htmlunit.QuietJavaScriptErrorListener;
import com.github.timurstrekalov.saga.core.htmlunit.WebResponseProxy;
import com.github.timurstrekalov.saga.core.util.HtmlUnitUtil;
import java.io.IOException;
import org.w3c.css.sac.ErrorHandler;

public final class WebClientFactory {
    private static final IncorrectnessListener quietIncorrectnessListener;
    private static final JavaScriptErrorListener loggingJsErrorListener;
    private static final HTMLParserListener quietHtmlParserListener;
    private static final SilentCssErrorHandler quietCssErrorHandler;

    private WebClientFactory() {
        throw new UnsupportedOperationException("Factory class");
    }

    public static WebClient newInstance(Config config) {
        return WebClientFactory.newInstance(config.getBrowserVersion());
    }

    public static WebClient newInstance(BrowserVersion version) {
        WebClient client = new WebClient(version){

            public WebResponse loadWebResponse(WebRequest webRequest) throws IOException {
                return new WebResponseProxy(super.loadWebResponse(webRequest));
            }
        };
        client.setIncorrectnessListener(quietIncorrectnessListener);
        client.setJavaScriptErrorListener(loggingJsErrorListener);
        client.setHTMLParserListener(quietHtmlParserListener);
        client.setCssErrorHandler((ErrorHandler)quietCssErrorHandler);
        client.getOptions().setJavaScriptEnabled(true);
        client.setAjaxController((AjaxController)new NicelyResynchronizingAjaxController());
        client.getOptions().setThrowExceptionOnScriptError(false);
        client.getOptions().setThrowExceptionOnFailingStatusCode(false);
        client.getOptions().setPrintContentOnFailingStatusCode(false);
        client.setWebConnection((WebConnection)new HttpWebConnection(client){

            protected WebResponse newWebResponseInstance(WebResponseData responseData, long loadTime, WebRequest request) {
                return new WebResponseProxy(super.newWebResponseInstance(responseData, loadTime, request));
            }
        });
        return client;
    }

    static {
        HtmlUnitUtil.silenceHtmlUnitLogging();
        quietIncorrectnessListener = new QuietIncorrectnessListener();
        loggingJsErrorListener = new QuietJavaScriptErrorListener();
        quietHtmlParserListener = new QuietHtmlParserListener();
        quietCssErrorHandler = new SilentCssErrorHandler();
    }
}

