/*
 * Decompiled with CFR 0.152.
 */
package com.github.timurstrekalov.saga.core.cfg;

import com.gargoylesoftware.htmlunit.BrowserVersion;
import com.github.timurstrekalov.saga.core.Order;
import com.github.timurstrekalov.saga.core.OutputStrategy;
import com.github.timurstrekalov.saga.core.ReportFormat;
import com.github.timurstrekalov.saga.core.SortBy;
import com.github.timurstrekalov.saga.core.cfg.Config;
import com.github.timurstrekalov.saga.core.instrumentation.InstrumentingBrowser;
import com.github.timurstrekalov.saga.core.util.UriUtil;
import com.google.common.base.Function;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Collections2;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import com.google.common.collect.Maps;
import com.google.common.collect.Sets;
import java.io.File;
import java.net.URI;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InstanceFieldPerPropertyConfig
implements Config {
    private static final Logger logger = LoggerFactory.getLogger(InstanceFieldPerPropertyConfig.class);
    private URI baseUri;
    private String baseDir;
    private File outputDir;
    private String includes;
    private String excludes;
    private Set<String> noInstrumentPatterns = Sets.newHashSet();
    private Set<ReportFormat> reportFormats = Config.DEFAULT_REPORT_FORMATS;
    private boolean outputInstrumentedFiles;
    private boolean cacheInstrumentedCode = true;
    private boolean includeInlineScripts = false;
    private OutputStrategy outputStrategy = Config.DEFAULT_OUTPUT_STRATEGY;
    private BrowserVersion browserVersion = Config.DEFAULT_BROWSER_VERSION;
    private int threadCount = Config.DEFAULT_THREAD_COUNT;
    private long backgroundJavaScriptTimeout = 300000L;
    private String sourcesToPreload;
    private String sourcesToPreloadEncoding = "UTF-8";
    private SortBy sortBy = Config.DEFAULT_SORT_BY;
    private Order order = Config.DEFAULT_ORDER;
    private String webDriverClassName = "org.openqa.selenium.htmlunit.HtmlUnitDriver";
    private InstrumentingBrowser browser = null;
    private Map<String, String> webDriverCapabilities = Maps.newHashMap();
    private List<String> sourceDirs;

    @Override
    public void setBaseDir(String baseDir) {
        this.baseDir = baseDir;
        this.baseUri = UriUtil.toUri(baseDir);
    }

    @Override
    public void setOutputDir(File outputDir) {
        this.outputDir = outputDir;
    }

    @Override
    public void setExcludes(String excludes) {
        this.excludes = excludes;
    }

    @Override
    public void setIncludes(String includes) {
        this.includes = includes;
    }

    @Override
    public void setNoInstrumentPatterns(Collection<String> noInstrumentPatterns) {
        if (noInstrumentPatterns != null) {
            this.noInstrumentPatterns = Sets.newHashSet(noInstrumentPatterns);
        }
    }

    @Override
    public void setNoInstrumentPatterns(String[] noInstrumentPatterns) {
        if (noInstrumentPatterns != null) {
            this.setNoInstrumentPatterns((Collection<String>)ImmutableList.copyOf((Object[])noInstrumentPatterns));
        }
    }

    @Override
    public void setOutputInstrumentedFiles(Boolean outputInstrumentedFiles) {
        if (outputInstrumentedFiles != null) {
            this.outputInstrumentedFiles = outputInstrumentedFiles;
        }
    }

    @Override
    public void setCacheInstrumentedCode(Boolean cacheInstrumentedCode) {
        if (cacheInstrumentedCode != null) {
            this.cacheInstrumentedCode = cacheInstrumentedCode;
        }
    }

    @Override
    public void setOutputStrategy(String outputStrategy) {
        if (outputStrategy != null) {
            this.setOutputStrategy(OutputStrategy.valueOf(outputStrategy.toUpperCase()));
        }
    }

    @Override
    public void setOutputStrategy(OutputStrategy outputStrategy) {
        if (outputStrategy != null) {
            this.outputStrategy = outputStrategy;
        }
    }

    @Override
    public void setThreadCount(Integer threadCount) {
        if (threadCount != null) {
            Preconditions.checkArgument((threadCount > 0 ? 1 : 0) != 0, (Object)"Thread count must be greater than zero");
            this.threadCount = threadCount;
        }
    }

    @Override
    public void setIncludeInlineScripts(Boolean includeInlineScripts) {
        if (includeInlineScripts != null) {
            this.includeInlineScripts = includeInlineScripts;
        }
    }

    @Override
    public void setBackgroundJavaScriptTimeout(Long backgroundJavaScriptTimeout) {
        if (backgroundJavaScriptTimeout != null) {
            this.backgroundJavaScriptTimeout = backgroundJavaScriptTimeout;
        }
    }

    @Override
    public void setSourcesToPreload(String sourcesToPreload) {
        if (sourcesToPreload != null) {
            this.sourcesToPreload = sourcesToPreload;
        }
    }

    @Override
    public void setSourcesToPreloadEncoding(String sourcesToPreloadEncoding) {
        if (sourcesToPreloadEncoding != null) {
            this.sourcesToPreloadEncoding = sourcesToPreloadEncoding;
        }
    }

    @Override
    public void setBrowserVersion(String browserVersion) {
        if (browserVersion != null) {
            try {
                logger.info("Setting {} as browser version", (Object)browserVersion);
                this.setBrowserVersion((BrowserVersion)BrowserVersion.class.getField(browserVersion).get(BrowserVersion.class));
            }
            catch (Exception e) {
                logger.error("Invalid browser version: {}", (Object)browserVersion);
                throw new RuntimeException(e);
            }
        }
    }

    @Override
    public void setBrowserVersion(BrowserVersion browserVersion) {
        this.browserVersion = browserVersion;
    }

    @Override
    public void setReportFormats(String reportFormatString) {
        if (reportFormatString == null) {
            return;
        }
        Iterable reportFormats = Splitter.on((String)",").omitEmptyStrings().trimResults().split((CharSequence)reportFormatString);
        logger.info("Setting {} as report formats", (Object)Joiner.on((String)", ").join(reportFormats));
        this.reportFormats = Sets.newHashSet((Iterable)Iterables.transform((Iterable)reportFormats, (Function)new Function<String, ReportFormat>(){

            public ReportFormat apply(String input) {
                return ReportFormat.valueOf(input.toUpperCase());
            }
        }));
    }

    @Override
    public void setSortBy(String sortBy) {
        if (sortBy == null) {
            return;
        }
        this.sortBy = SortBy.valueOf(sortBy.trim().toUpperCase());
    }

    @Override
    public void setOrder(String order) {
        if (order == null) {
            return;
        }
        this.order = Order.fromString(order.trim());
    }

    @Override
    public URI getBaseUri() {
        return this.baseUri;
    }

    @Override
    public String getBaseDir() {
        return this.baseDir;
    }

    @Override
    public File getOutputDir() {
        return this.outputDir;
    }

    @Override
    public String getIncludes() {
        return this.includes;
    }

    @Override
    public String getExcludes() {
        return this.excludes;
    }

    @Override
    public Set<String> getNoInstrumentPatterns() {
        return this.noInstrumentPatterns;
    }

    @Override
    public boolean isOutputInstrumentedFiles() {
        return this.outputInstrumentedFiles;
    }

    @Override
    public boolean isCacheInstrumentedCode() {
        return this.cacheInstrumentedCode;
    }

    @Override
    public OutputStrategy getOutputStrategy() {
        return this.outputStrategy;
    }

    @Override
    public int getThreadCount() {
        return this.threadCount;
    }

    @Override
    public boolean isIncludeInlineScripts() {
        return this.includeInlineScripts;
    }

    @Override
    public long getBackgroundJavaScriptTimeout() {
        return this.backgroundJavaScriptTimeout;
    }

    @Override
    public String getSourcesToPreload() {
        return this.sourcesToPreload;
    }

    @Override
    public String getSourcesToPreloadEncoding() {
        return this.sourcesToPreloadEncoding;
    }

    @Override
    public BrowserVersion getBrowserVersion() {
        return this.browserVersion;
    }

    @Override
    public Set<ReportFormat> getReportFormats() {
        return this.reportFormats;
    }

    @Override
    public SortBy getSortBy() {
        return this.sortBy;
    }

    @Override
    public Order getOrder() {
        return this.order;
    }

    @Override
    public void setWebDriverClassName(String webDriverClassName) {
        if (webDriverClassName == null) {
            return;
        }
        this.webDriverClassName = webDriverClassName;
    }

    @Override
    public void setInstrumentingBrowser(InstrumentingBrowser browser) {
        this.browser = browser;
    }

    @Override
    public String getWebDriverClassName() {
        return this.webDriverClassName;
    }

    @Override
    public InstrumentingBrowser getInstrumentingBrowser() {
        return this.browser;
    }

    @Override
    public File getInstrumentedFileDirectory() {
        return new File(this.outputDir, "instrumented");
    }

    @Override
    public Collection<Pattern> getIgnorePatterns() {
        return Collections2.transform(this.getNoInstrumentPatterns(), (Function)new Function<String, Pattern>(){

            public Pattern apply(String input) {
                return Pattern.compile(input);
            }
        });
    }

    @Override
    public void setWebDriverCapabilities(Map<String, String> webDriverCapabilities) {
        if (webDriverCapabilities == null) {
            return;
        }
        this.webDriverCapabilities = webDriverCapabilities;
    }

    @Override
    public Map<String, String> getWebDriverCapabilities() {
        return this.webDriverCapabilities;
    }

    @Override
    public void setSourceDir(List<String> sourceDirs) {
        this.sourceDirs = sourceDirs;
    }

    @Override
    public List<String> getSourceDirs() {
        return this.sourceDirs;
    }
}

