/*
 * Decompiled with CFR 0.152.
 */
package com.github.timurstrekalov.saga.core;

import com.github.timurstrekalov.saga.core.OutputStrategy;
import com.github.timurstrekalov.saga.core.WritesStatistics;
import com.github.timurstrekalov.saga.core.cfg.Config;
import com.github.timurstrekalov.saga.core.instrumentation.InstrumentingBrowser;
import com.github.timurstrekalov.saga.core.instrumentation.InstrumentingBrowserFactory;
import com.github.timurstrekalov.saga.core.model.ScriptCoverageStatistics;
import com.github.timurstrekalov.saga.core.model.ScriptData;
import com.github.timurstrekalov.saga.core.model.TestRunCoverageStatistics;
import com.github.timurstrekalov.saga.core.util.UriUtil;
import java.io.IOException;
import java.net.URI;
import java.util.Map;
import java.util.concurrent.Callable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class TestRunCoverageStatisticsCallable
implements Callable<TestRunCoverageStatistics> {
    private static final Logger logger = LoggerFactory.getLogger(TestRunCoverageStatisticsCallable.class);
    private static final ThreadLocal<InstrumentingBrowser> localBrowser = new ThreadLocal();
    private final Config config;
    private final URI test;
    private final OutputStrategy outputStrategy;

    public TestRunCoverageStatisticsCallable(Config config, URI test, OutputStrategy outputStrategy) {
        this.config = config;
        this.test = test;
        this.outputStrategy = outputStrategy;
    }

    /*
     * Loose catch block
     */
    @Override
    public TestRunCoverageStatistics call() {
        try {
            logger.info("Running test at {}", (Object)this.test.toString());
            try {
                TestRunCoverageStatistics runStats = this.runTest(this.test);
                if (runStats == TestRunCoverageStatistics.EMPTY) {
                    logger.warn("No actual test run for file: {}", (Object)this.test);
                } else if (this.outputStrategy.contains(OutputStrategy.PER_TEST)) {
                    if (UriUtil.isFileUri(this.test)) {
                        new WritesStatistics().write(this.config, runStats);
                    } else {
                        logger.warn("Output strategy PER_TEST only makes sense in the context of tests run off the filesystem, ignoring");
                    }
                }
                TestRunCoverageStatistics testRunCoverageStatistics = runStats;
                return testRunCoverageStatistics;
            }
            catch (IOException e) {
                TestRunCoverageStatistics testRunCoverageStatistics;
                block14: {
                    testRunCoverageStatistics = TestRunCoverageStatistics.EMPTY;
                    if (localBrowser.get() == null || this.config.getInstrumentingBrowser() != null) break block14;
                    logger.info("Quitting browser");
                    localBrowser.get().quit();
                }
                return testRunCoverageStatistics;
            }
            catch (RuntimeException e) {
                logger.warn("Error running test {}: {}", (Object)this.test.toString(), (Object)e.getMessage());
                throw e;
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
            }
        }
        finally {
            if (localBrowser.get() != null && this.config.getInstrumentingBrowser() == null) {
                logger.info("Quitting browser");
                localBrowser.get().quit();
            }
        }
    }

    private TestRunCoverageStatistics runTest(URI test) throws IOException {
        InstrumentingBrowser browser = this.getLocalBrowser();
        browser.get(test.toASCIIString());
        Map<String, Map<String, Long>> coverageData = browser.extractCoverageDataVariable();
        if (coverageData == null) {
            return TestRunCoverageStatistics.EMPTY;
        }
        return this.collectAndWriteRunStats(test, coverageData);
    }

    private TestRunCoverageStatistics collectAndWriteRunStats(URI test, Map<String, Map<String, Long>> coverageDataForAllScripts) throws IOException {
        TestRunCoverageStatistics runStats = new TestRunCoverageStatistics(test);
        runStats.setSortBy(this.config.getSortBy());
        runStats.setOrder(this.config.getOrder());
        URI baseUri = this.config.getBaseUri();
        for (ScriptData data : this.getLocalBrowser().getScriptDataList()) {
            String sourceUri = data.getSourceUriAsString();
            Map<String, Long> coverageDataForScript = coverageDataForAllScripts.get(sourceUri);
            ScriptCoverageStatistics scriptCoverageStatistics = data.generateScriptCoverageStatistics(baseUri, coverageDataForScript);
            runStats.add(scriptCoverageStatistics);
        }
        return runStats;
    }

    private InstrumentingBrowser getLocalBrowser() {
        if (this.config.getInstrumentingBrowser() != null) {
            return this.config.getInstrumentingBrowser();
        }
        if (localBrowser.get() == null) {
            localBrowser.set(InstrumentingBrowserFactory.newInstance(this.config));
        }
        return localBrowser.get();
    }
}

