/*
 * Decompiled with CFR 0.152.
 */
package com.github.timurstrekalov.saga.core;

import com.google.common.collect.ImmutableMap;
import java.util.Locale;
import java.util.Map;

public enum Order {
    ASC,
    DESC;

    private static final Map<String, Order> map;

    public static Order fromString(String name) {
        String lowercaseName = name.toLowerCase(Locale.ENGLISH);
        if (!map.containsKey(lowercaseName)) {
            throw new IllegalArgumentException("Unknown Ordering name: " + name);
        }
        return map.get(lowercaseName);
    }

    static {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        builder.put((Object)"asc", (Object)ASC);
        builder.put((Object)"desc", (Object)DESC);
        builder.put((Object)"ascending", (Object)ASC);
        builder.put((Object)"descending", (Object)DESC);
        map = builder.build();
    }
}

