/*
 * Decompiled with CFR 0.152.
 */
package com.github.timurstrekalov.saga.core;

import com.github.timurstrekalov.saga.core.CoverageGenerator;
import com.github.timurstrekalov.saga.core.OutputStrategy;
import com.github.timurstrekalov.saga.core.TestRunCoverageStatisticsCallable;
import com.github.timurstrekalov.saga.core.WritesStatistics;
import com.github.timurstrekalov.saga.core.cfg.Config;
import com.github.timurstrekalov.saga.core.cfg.InstanceFieldPerPropertyConfig;
import com.github.timurstrekalov.saga.core.model.ScriptCoverageStatistics;
import com.github.timurstrekalov.saga.core.model.TestRunCoverageStatistics;
import com.github.timurstrekalov.saga.core.sourcepreloader.FileSystemSourcePreloader;
import com.github.timurstrekalov.saga.core.testfetcher.TestFetcher;
import com.github.timurstrekalov.saga.core.testfetcher.TestFetcherFactory;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import java.util.concurrent.ExecutorCompletionService;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import org.codehaus.plexus.util.FileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultCoverageGenerator
implements CoverageGenerator {
    private static final String TOTAL_REPORT_NAME = "total";
    private static final String INLINE_SCRIPT_RE = ".+__from_\\d+_\\d+_to_\\d+_\\d+$";
    private static final Logger logger = LoggerFactory.getLogger(DefaultCoverageGenerator.class);
    private final Config config;

    DefaultCoverageGenerator() {
        this(new InstanceFieldPerPropertyConfig());
    }

    DefaultCoverageGenerator(Config config) {
        this.config = config;
    }

    @Override
    public void instrumentAndGenerateReports() throws IOException {
        Preconditions.checkNotNull((Object)this.config.getBaseDir(), (Object)"baseDir cannot be null");
        Preconditions.checkNotNull((Object)this.config.getOutputDir(), (Object)"outputDir cannot be null");
        URI baseUri = this.config.getBaseUri();
        List<URI> tests = this.fetchTests(baseUri);
        if (tests.isEmpty()) {
            logger.warn("No tests found, exiting");
            return;
        }
        int actualThreadCount = Math.min(this.config.getThreadCount(), tests.size());
        logger.info("Using up to {} threads", (Object)actualThreadCount);
        OutputStrategy outputStrategy = this.config.getOutputStrategy();
        logger.info("Output strategy set to {}", (Object)outputStrategy);
        if (!this.config.isIncludeInlineScripts()) {
            this.config.getNoInstrumentPatterns().add(INLINE_SCRIPT_RE);
            this.config.getNoInstrumentPatterns().add(".+JavaScriptStringJob");
            this.config.getNoInstrumentPatterns().add(".+#\\d+\\(eval\\)\\(\\d+\\)");
            this.config.getNoInstrumentPatterns().add("injected script");
        }
        if (!this.config.getNoInstrumentPatterns().isEmpty()) {
            logger.info("Using the following no-instrument patterns:\n\t{}", (Object)Joiner.on((String)"\n\t").join(this.config.getNoInstrumentPatterns()));
        }
        File outputDir = this.config.getOutputDir();
        FileUtils.mkdir((String)outputDir.getAbsolutePath());
        if (this.config.isOutputInstrumentedFiles()) {
            FileUtils.mkdir((String)this.config.getInstrumentedFileDirectory().getAbsolutePath());
        }
        TestRunCoverageStatistics totalStats = new TestRunCoverageStatistics(baseUri.relativize(URI.create(TOTAL_REPORT_NAME)), "Total coverage report");
        totalStats.setSortBy(this.config.getSortBy());
        totalStats.setOrder(this.config.getOrder());
        totalStats.setSourceDirs(this.config.getSourceDirs());
        this.maybePreloadSources(totalStats);
        this.runTests(tests, actualThreadCount, outputStrategy, totalStats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void runTests(List<URI> tests, int actualThreadCount, OutputStrategy outputStrategy, TestRunCoverageStatistics totalStats) throws IOException {
        ExecutorService executorService = Executors.newFixedThreadPool(actualThreadCount);
        ExecutorCompletionService<TestRunCoverageStatistics> completionService = new ExecutorCompletionService<TestRunCoverageStatistics>(executorService);
        for (URI test : tests) {
            completionService.submit(new TestRunCoverageStatisticsCallable(this.config, test, outputStrategy));
        }
        LinkedList allRunStats = Lists.newLinkedList();
        int submittedTasks = tests.size();
        try {
            for (int i = 0; i < submittedTasks; ++i) {
                try {
                    Future future = completionService.take();
                    TestRunCoverageStatistics runStats = (TestRunCoverageStatistics)future.get();
                    allRunStats.add(runStats);
                    continue;
                }
                catch (Exception e) {
                    logger.debug(e.getMessage(), (Throwable)e);
                }
            }
        }
        finally {
            executorService.shutdown();
        }
        logger.info("Test run finished");
        if (outputStrategy.contains(OutputStrategy.TOTAL)) {
            for (TestRunCoverageStatistics runStats : allRunStats) {
                if (runStats == TestRunCoverageStatistics.EMPTY) continue;
                for (ScriptCoverageStatistics scriptCoverageStatistics : runStats) {
                    totalStats.add(scriptCoverageStatistics);
                }
            }
            new WritesStatistics().write(this.config, totalStats);
        }
    }

    private void maybePreloadSources(TestRunCoverageStatistics totalStats) throws IOException {
        new FileSystemSourcePreloader().preloadSources(this.config, totalStats);
    }

    @Override
    public Config getConfig() {
        return this.config;
    }

    private List<URI> fetchTests(URI baseDir) throws IOException {
        TestFetcher fetcher = TestFetcherFactory.newInstance(baseDir);
        List<URI> tests = fetcher.fetch(baseDir, this.config.getIncludes(), this.config.getExcludes());
        logger.info("{} tests found", (Object)tests.size());
        return tests;
    }
}

