/*
 * Decompiled with CFR 0.152.
 */
package io.ticofab.androidgpxparser.parser.domain;

import io.ticofab.androidgpxparser.parser.domain.Link;
import io.ticofab.androidgpxparser.parser.domain.TrackSegment;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class Track {
    private final String mTrackName;
    private final List<TrackSegment> mTrackSegments;
    private final String mTrackDesc;
    private final String mTrackCmt;
    private final String mTrackSrc;
    private final Integer mTrackNumber;
    private final Link mTrackLink;
    private final String mTrackType;

    private Track(Builder builder) {
        this.mTrackName = builder.mTrackName;
        this.mTrackDesc = builder.mTrackDesc;
        this.mTrackCmt = builder.mTrackCmt;
        this.mTrackSrc = builder.mTrackSrc;
        this.mTrackNumber = builder.mTrackNumber;
        this.mTrackSegments = Collections.unmodifiableList(new ArrayList<TrackSegment>(builder.mTrackSegments));
        this.mTrackLink = builder.mTrackLink;
        this.mTrackType = builder.mTrackType;
    }

    public String getTrackName() {
        return this.mTrackName;
    }

    public String getTrackDesc() {
        return this.mTrackDesc;
    }

    public String getTrackCmt() {
        return this.mTrackCmt;
    }

    public String getTrackSrc() {
        return this.mTrackSrc;
    }

    public Integer getTrackNumber() {
        return this.mTrackNumber;
    }

    public Link getTrackLink() {
        return this.mTrackLink;
    }

    public String getTrackType() {
        return this.mTrackType;
    }

    public List<TrackSegment> getTrackSegments() {
        return this.mTrackSegments;
    }

    public static class Builder {
        private String mTrackName;
        private List<TrackSegment> mTrackSegments;
        private String mTrackDesc;
        private String mTrackCmt;
        private String mTrackSrc;
        private Integer mTrackNumber;
        private Link mTrackLink;
        private String mTrackType;

        public Builder setTrackName(String trackName) {
            this.mTrackName = trackName;
            return this;
        }

        public Builder setTrackDesc(String trackDesc) {
            this.mTrackDesc = trackDesc;
            return this;
        }

        public Builder setTrackSegments(List<TrackSegment> trackSegments) {
            this.mTrackSegments = trackSegments;
            return this;
        }

        public Builder setTrackCmt(String trackCmt) {
            this.mTrackCmt = trackCmt;
            return this;
        }

        public Builder setTrackSrc(String trackSrc) {
            this.mTrackSrc = trackSrc;
            return this;
        }

        public Builder setTrackNumber(Integer trackNumber) {
            this.mTrackNumber = trackNumber;
            return this;
        }

        public Builder setTrackLink(Link link) {
            this.mTrackLink = link;
            return this;
        }

        public Builder setTrackType(String type) {
            this.mTrackType = type;
            return this;
        }

        public Track build() {
            return new Track(this);
        }
    }
}

