/*
 * Decompiled with CFR 0.152.
 */
package com.davemorrissey.labs.subscaleview.decoder;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.BitmapRegionDecoder;
import android.graphics.Point;
import android.graphics.Rect;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Keep;
import com.davemorrissey.labs.subscaleview.SubsamplingScaleImageView;
import com.davemorrissey.labs.subscaleview.decoder.ImageRegionDecoder;
import java.io.InputStream;
import java.util.List;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0017\u00a2\u0006\u0002\u0010\u0002B\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\u000e\u001a\u00020\u000f2\u0006\u0010\u0010\u001a\u00020\u00112\u0006\u0010\u0012\u001a\u00020\u0013H\u0016J\u0018\u0010\u0014\u001a\u00020\u00152\u0006\u0010\u0016\u001a\u00020\u00172\u0006\u0010\u0018\u001a\u00020\u0019H\u0016J\b\u0010\u001a\u001a\u00020\u001bH\u0016J\b\u0010\u001c\u001a\u00020\u001dH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0010\u0010\n\u001a\u0004\u0018\u00010\u000bX\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\f\u001a\u00020\rX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u001e"}, d2={"Lcom/davemorrissey/labs/subscaleview/decoder/SkiaImageRegionDecoder;", "Lcom/davemorrissey/labs/subscaleview/decoder/ImageRegionDecoder;", "()V", "bitmapConfig", "Landroid/graphics/Bitmap$Config;", "(Landroid/graphics/Bitmap$Config;)V", "ASSET_PREFIX", "", "FILE_PREFIX", "RESOURCE_PREFIX", "decoder", "Landroid/graphics/BitmapRegionDecoder;", "decoderLock", "Ljava/util/concurrent/locks/ReentrantReadWriteLock;", "decodeRegion", "Landroid/graphics/Bitmap;", "sRect", "Landroid/graphics/Rect;", "sampleSize", "", "init", "Landroid/graphics/Point;", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "isReady", "", "recycle", "", "subsampling-scale-image-view_release"})
public final class SkiaImageRegionDecoder
implements ImageRegionDecoder {
    private final String FILE_PREFIX = "file://";
    private final String ASSET_PREFIX = this.FILE_PREFIX + "/android_asset/";
    private final String RESOURCE_PREFIX = "android.resource://";
    private BitmapRegionDecoder decoder;
    private final ReentrantReadWriteLock decoderLock = new ReentrantReadWriteLock(true);
    private final Bitmap.Config bitmapConfig;

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public synchronized boolean isReady() {
        if (this.decoder == null) return false;
        BitmapRegionDecoder bitmapRegionDecoder = this.decoder;
        if (bitmapRegionDecoder == null) {
            Intrinsics.throwNpe();
        }
        if (bitmapRegionDecoder.isRecycled()) return false;
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Point init(@NotNull Context context, @NotNull Uri uri) throws Exception {
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        String string = uri.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"uri.toString()");
        String uriString = string;
        if (StringsKt.startsWith$default((String)uriString, (String)this.RESOURCE_PREFIX, (boolean)false, (int)2, null)) {
            Resources resources;
            String packageName = uri.getAuthority();
            if (Intrinsics.areEqual((Object)context.getPackageName(), (Object)packageName)) {
                resources = context.getResources();
            } else {
                PackageManager pm = context.getPackageManager();
                resources = pm.getResourcesForApplication(packageName);
            }
            Resources res = resources;
            int id = 0;
            List segments = uri.getPathSegments();
            int size = segments.size();
            if (size == 2 && Intrinsics.areEqual((Object)((String)segments.get(0)), (Object)"drawable")) {
                String resName = (String)segments.get(1);
                id = res.getIdentifier(resName, "drawable", packageName);
            } else if (size == 1 && TextUtils.isDigitsOnly((CharSequence)((CharSequence)segments.get(0)))) {
                try {
                    id = Integer.parseInt((String)segments.get(0));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            this.decoder = BitmapRegionDecoder.newInstance((InputStream)context.getResources().openRawResource(id), (boolean)false);
        } else if (StringsKt.startsWith$default((String)uriString, (String)this.ASSET_PREFIX, (boolean)false, (int)2, null)) {
            String res = uriString;
            int n = this.ASSET_PREFIX.length();
            String string2 = res;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String assetName = string3;
            this.decoder = BitmapRegionDecoder.newInstance((InputStream)context.getAssets().open(assetName, 1), (boolean)false);
        } else if (StringsKt.startsWith$default((String)uriString, (String)this.FILE_PREFIX, (boolean)false, (int)2, null)) {
            String assetName = uriString;
            int res = this.FILE_PREFIX.length();
            SkiaImageRegionDecoder skiaImageRegionDecoder = this;
            String string4 = assetName;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(res);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            String string6 = string5;
            skiaImageRegionDecoder.decoder = BitmapRegionDecoder.newInstance((String)string6, (boolean)false);
        } else {
            InputStream inputStream = null;
            try {
                ContentResolver contentResolver = context.getContentResolver();
                inputStream = contentResolver.openInputStream(uri);
                this.decoder = BitmapRegionDecoder.newInstance((InputStream)inputStream, (boolean)false);
            }
            finally {
                try {
                    InputStream inputStream2 = inputStream;
                    if (inputStream2 != null) {
                        inputStream2.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        BitmapRegionDecoder bitmapRegionDecoder = this.decoder;
        if (bitmapRegionDecoder == null) {
            Intrinsics.throwNpe();
        }
        int n = bitmapRegionDecoder.getWidth();
        BitmapRegionDecoder bitmapRegionDecoder2 = this.decoder;
        if (bitmapRegionDecoder2 == null) {
            Intrinsics.throwNpe();
        }
        return new Point(n, bitmapRegionDecoder2.getHeight());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bitmap decodeRegion(@NotNull Rect sRect, int sampleSize) {
        Intrinsics.checkParameterIsNotNull((Object)sRect, (String)"sRect");
        this.decoderLock.readLock().lock();
        try {
            if (this.decoder != null) {
                BitmapRegionDecoder bitmapRegionDecoder = this.decoder;
                if (bitmapRegionDecoder == null) {
                    Intrinsics.throwNpe();
                }
                if (!bitmapRegionDecoder.isRecycled()) {
                    BitmapFactory.Options options = new BitmapFactory.Options();
                    options.inSampleSize = sampleSize;
                    options.inPreferredConfig = this.bitmapConfig;
                    BitmapRegionDecoder bitmapRegionDecoder2 = this.decoder;
                    if (bitmapRegionDecoder2 == null) {
                        Intrinsics.throwNpe();
                    }
                    Bitmap bitmap = bitmapRegionDecoder2.decodeRegion(sRect, options);
                    if (bitmap == null) {
                        throw (Throwable)new RuntimeException("Skia image decoder returned null bitmap - image format may not be supported");
                    }
                    Bitmap bitmap2 = bitmap;
                    return bitmap2;
                }
            }
            throw (Throwable)new IllegalStateException("Cannot decode region after decoder has been recycled");
        }
        finally {
            this.decoderLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void recycle() {
        this.decoderLock.writeLock().lock();
        try {
            BitmapRegionDecoder bitmapRegionDecoder = this.decoder;
            if (bitmapRegionDecoder == null) {
                Intrinsics.throwNpe();
            }
            bitmapRegionDecoder.recycle();
            this.decoder = null;
        }
        finally {
            this.decoderLock.writeLock().unlock();
        }
    }

    public SkiaImageRegionDecoder(@Nullable Bitmap.Config bitmapConfig) {
        Bitmap.Config globalBitmapConfig = SubsamplingScaleImageView.Companion.getPreferredBitmapConfig();
        this.bitmapConfig = bitmapConfig != null ? bitmapConfig : (globalBitmapConfig != null ? globalBitmapConfig : Bitmap.Config.RGB_565);
    }

    @Keep
    public SkiaImageRegionDecoder() {
        this(null);
    }
}

