/*
 * Decompiled with CFR 0.152.
 */
package com.davemorrissey.labs.subscaleview.decoder;

import android.content.ContentResolver;
import android.content.Context;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.text.TextUtils;
import androidx.annotation.Keep;
import com.davemorrissey.labs.subscaleview.SubsamplingScaleImageView;
import com.davemorrissey.labs.subscaleview.decoder.ImageDecoder;
import java.io.InputStream;
import java.util.List;
import kotlin.Metadata;
import kotlin.TypeCastException;
import kotlin.jvm.internal.Intrinsics;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 13}, bv={1, 0, 3}, k=1, d1={"\u0000.\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\u0018\u00002\u00020\u0001B\u0007\b\u0017\u00a2\u0006\u0002\u0010\u0002B\u000f\u0012\b\u0010\u0003\u001a\u0004\u0018\u00010\u0004\u00a2\u0006\u0002\u0010\u0005J\u0018\u0010\n\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\u000fH\u0016R\u000e\u0010\u0006\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\u0007X\u0082D\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0003\u001a\u00020\u0004X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006\u0010"}, d2={"Lcom/davemorrissey/labs/subscaleview/decoder/SkiaImageDecoder;", "Lcom/davemorrissey/labs/subscaleview/decoder/ImageDecoder;", "()V", "bitmapConfig", "Landroid/graphics/Bitmap$Config;", "(Landroid/graphics/Bitmap$Config;)V", "ASSET_PREFIX", "", "FILE_PREFIX", "RESOURCE_PREFIX", "decode", "Landroid/graphics/Bitmap;", "context", "Landroid/content/Context;", "uri", "Landroid/net/Uri;", "subsampling-scale-image-view_release"})
public final class SkiaImageDecoder
implements ImageDecoder {
    private final String FILE_PREFIX = "file://";
    private final String ASSET_PREFIX = this.FILE_PREFIX + "/android_asset/";
    private final String RESOURCE_PREFIX = "android.resource://";
    private final Bitmap.Config bitmapConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    @NotNull
    public Bitmap decode(@NotNull Context context, @NotNull Uri uri) throws Exception {
        Bitmap bitmap;
        Intrinsics.checkParameterIsNotNull((Object)context, (String)"context");
        Intrinsics.checkParameterIsNotNull((Object)uri, (String)"uri");
        String string = uri.toString();
        Intrinsics.checkExpressionValueIsNotNull((Object)string, (String)"uri.toString()");
        String uriString = string;
        BitmapFactory.Options options = new BitmapFactory.Options();
        options.inPreferredConfig = this.bitmapConfig;
        if (StringsKt.startsWith$default((String)uriString, (String)this.RESOURCE_PREFIX, (boolean)false, (int)2, null)) {
            Resources resources;
            String packageName = uri.getAuthority();
            if (Intrinsics.areEqual((Object)context.getPackageName(), (Object)packageName)) {
                resources = context.getResources();
            } else {
                PackageManager pm = context.getPackageManager();
                resources = pm.getResourcesForApplication(packageName);
            }
            Resources res = resources;
            int id = 0;
            List segments = uri.getPathSegments();
            int size = segments.size();
            if (size == 2 && Intrinsics.areEqual((Object)((String)segments.get(0)), (Object)"drawable")) {
                String resName = (String)segments.get(1);
                id = res.getIdentifier(resName, "drawable", packageName);
            } else if (size == 1 && TextUtils.isDigitsOnly((CharSequence)((CharSequence)segments.get(0)))) {
                try {
                    id = Integer.parseInt((String)segments.get(0));
                }
                catch (NumberFormatException numberFormatException) {
                    // empty catch block
                }
            }
            bitmap = BitmapFactory.decodeResource((Resources)context.getResources(), (int)id, (BitmapFactory.Options)options);
        } else if (StringsKt.startsWith$default((String)uriString, (String)this.ASSET_PREFIX, (boolean)false, (int)2, null)) {
            String res = uriString;
            int n = this.ASSET_PREFIX.length();
            String string2 = res;
            if (string2 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string3 = string2.substring(n);
            Intrinsics.checkExpressionValueIsNotNull((Object)string3, (String)"(this as java.lang.String).substring(startIndex)");
            String assetName = string3;
            bitmap = BitmapFactory.decodeStream((InputStream)context.getAssets().open(assetName), null, (BitmapFactory.Options)options);
        } else if (StringsKt.startsWith$default((String)uriString, (String)this.FILE_PREFIX, (boolean)false, (int)2, null)) {
            String assetName = uriString;
            int res = this.FILE_PREFIX.length();
            String string4 = assetName;
            if (string4 == null) {
                throw new TypeCastException("null cannot be cast to non-null type java.lang.String");
            }
            String string5 = string4.substring(res);
            Intrinsics.checkExpressionValueIsNotNull((Object)string5, (String)"(this as java.lang.String).substring(startIndex)");
            bitmap = BitmapFactory.decodeFile((String)string5, (BitmapFactory.Options)options);
        } else {
            InputStream inputStream = null;
            try {
                ContentResolver contentResolver = context.getContentResolver();
                inputStream = contentResolver.openInputStream(uri);
                bitmap = BitmapFactory.decodeStream((InputStream)inputStream, null, (BitmapFactory.Options)options);
            }
            finally {
                try {
                    InputStream inputStream2 = inputStream;
                    if (inputStream2 != null) {
                        inputStream2.close();
                    }
                }
                catch (Exception exception) {}
            }
        }
        if (bitmap == null) {
            throw (Throwable)new RuntimeException("Skia image region decoder returned null bitmap - image format may not be supported");
        }
        return bitmap;
    }

    public SkiaImageDecoder(@Nullable Bitmap.Config bitmapConfig) {
        Bitmap.Config globalBitmapConfig = SubsamplingScaleImageView.Companion.getPreferredBitmapConfig();
        this.bitmapConfig = bitmapConfig != null ? bitmapConfig : (globalBitmapConfig != null ? globalBitmapConfig : Bitmap.Config.RGB_565);
    }

    @Keep
    public SkiaImageDecoder() {
        this(null);
    }
}

