/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.logger;

import android.support.annotation.NonNull;
import com.orhanobut.logger.LogBuilder;
import com.orhanobut.logger.PrintStyle;
import timber.log.Timber;

public final class LogPrinter
extends Timber.DebugTree {
    private PrintStyle style;
    private boolean isCustomTag = true;
    private final LogBuilder logBuilder;
    private static final String PROPERTY = System.getProperty("line.separator");

    LogPrinter(LogBuilder logBuilder) {
        this.logBuilder = logBuilder;
        this.style = logBuilder.style;
    }

    protected String createStackElementTag(StackTraceElement ignored) {
        String tag;
        this.isCustomTag = false;
        if (this.logBuilder.globalTag != null) {
            tag = this.logBuilder.globalTag;
        } else {
            int offset = 9 + this.logBuilder.methodOffset - 2;
            StackTraceElement[] stackTrace = new Throwable().getStackTrace();
            int length = stackTrace.length;
            tag = super.createStackElementTag(length > offset ? stackTrace[offset] : stackTrace[length - 1]);
        }
        return this.maybeAddPrefix(tag);
    }

    public String maybeAddPrefix(String tag) {
        String tagPrefix = this.logBuilder.tagPrefix;
        if (tagPrefix != null) {
            tag = tagPrefix + "-" + tag;
        }
        return tag;
    }

    protected void log(int priority, String tag, @NonNull String message, Throwable ignored) {
        if (this.style.beforePrint() != null) {
            super.log(priority, tag, this.style.beforePrint(), null);
        }
        String[] lines = message.split(PROPERTY);
        int length = lines.length;
        for (int i = 0; i < length; ++i) {
            String logStr = this.style.printLog(lines[i], i, length);
            super.log(priority, tag, logStr, null);
        }
        if (this.style.afterPrint() != null) {
            super.log(priority, tag, this.style.afterPrint(), null);
        }
        this.isCustomTag = true;
    }

    protected boolean isLoggable(String tag, int priority) {
        return priority >= this.logBuilder.priority;
    }

    boolean isCustomTag() {
        return this.isCustomTag;
    }

    public LogBuilder getLogBuilder() {
        return this.logBuilder;
    }
}

