/*
 * Decompiled with CFR 0.152.
 */
package com.orhanobut.logger;

import android.support.annotation.NonNull;
import com.orhanobut.logger.PrintStyle;

public class LogPrintStyle
extends PrintStyle {
    private static final String PREFIX_BORDER = "\u2551 ";
    private StringBuilder sb = new StringBuilder();

    @Override
    public String beforePrint() {
        return null;
    }

    @Override
    @NonNull
    public String printLog(String message, int line, int wholeCount) {
        if (line == wholeCount - 1) {
            return "\u255a " + message + this.getTail();
        }
        return PREFIX_BORDER + message;
    }

    @Override
    public String afterPrint() {
        return null;
    }

    private String getTail() {
        if (!this.getSettings().showMethodLink) {
            return "";
        }
        int index = 9 + this.getSettings().methodOffset + 1;
        if (this.getPrinter().isCustomTag()) {
            index -= 2;
        }
        StackTraceElement stack = Thread.currentThread().getStackTrace()[index];
        if (this.sb.length() < 0) {
            this.sb = new StringBuilder();
        } else {
            this.sb.setLength(0);
        }
        this.sb.append(String.format(" ==> %s(%s:%s)", stack.getMethodName(), stack.getFileName(), stack.getLineNumber()));
        if (this.getSettings().showThreadInfo) {
            this.sb.append(" Thread: ").append(Thread.currentThread().getName());
        }
        return this.sb.toString();
    }
}

